/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database;

import com.plusmpm.security.TextCipher;
import com.suncode.dbexplorer.database.ConnectionStringDomain;
import com.suncode.dbexplorer.database.DatabaseType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ConnectionString {
    private DatabaseType type;
    private String catalog;
    private String schema;
    private String host;
    private Integer port;
    private String user;
    private String password;
    private String jdbcUrl;

    public ConnectionString(DatabaseType type, String catalog, String schema, String host, Integer port, String user, String password, String jdbcUrl) {
        if (!this.notEmpty(jdbcUrl)) {
            Assert.hasText((String)host, (String)"Database host cannot be empty if JDBC URL is not specified");
            Assert.notNull((Object)((Object)type), (String)"[Assertion failed] - this argument is required; it must not be null");
        }
        this.type = type;
        this.catalog = catalog;
        this.schema = schema;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.jdbcUrl = jdbcUrl;
    }

    public boolean catalogSpecified() {
        return this.notEmpty(this.catalog);
    }

    public boolean schemaSpecified() {
        return this.notEmpty(this.schema);
    }

    private boolean notEmpty(String string) {
        return StringUtils.hasText((String)string);
    }

    public static ConnectionString fromDomain(ConnectionStringDomain domain) {
        return ConnectionString.builder().catalog(domain.getCatalog()).host(domain.getHost()).jdbcUrl(domain.getJdbcUrl()).password(TextCipher.decrypt((String)domain.getPassword())).port(domain.getPort()).schema(domain.getSchema()).type(domain.getType()).user(domain.getUser()).build();
    }

    public static ConnectionString fromJdbcUrl(ConnectionStringDomain domain) {
        return ConnectionString.builder().jdbcUrl(domain.getJdbcUrl()).password(TextCipher.decrypt((String)domain.getPassword())).schema(domain.getSchema()).user(domain.getUser()).build();
    }

    public static ConnectionStringDomain toDomain(ConnectionString connectionString) {
        return ConnectionStringDomain.builder().catalog(connectionString.getCatalog()).host(connectionString.getHost()).jdbcUrl(connectionString.getJdbcUrl()).password(TextCipher.encrypt((String)connectionString.getPassword())).port(connectionString.getPort()).schema(connectionString.getSchema()).type(connectionString.getType()).user(connectionString.getUser()).build();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConnectionString)) {
            return false;
        }
        ConnectionString other = (ConnectionString)obj;
        return new EqualsBuilder().append((Object)this.catalog, (Object)other.catalog).append((Object)this.schema, (Object)other.schema).append((Object)this.host, (Object)other.host).append((Object)this.port, (Object)other.port).append((Object)this.type, (Object)other.type).append((Object)this.user, (Object)other.user).append((Object)this.password, (Object)other.password).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.catalog).append((Object)this.schema).append((Object)this.host).append((Object)this.port).append((Object)this.type).append((Object)this.user).append((Object)this.password).toHashCode();
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append(this.getClass().getSimpleName()).append("( ").append(this.catalog).append("@").append(this.host);
        if (this.host != null) {
            s.append(":").append(this.host);
        }
        return s.append(")").toString();
    }

    public static ConnectionStringBuilder builder() {
        return new ConnectionStringBuilder();
    }

    public DatabaseType getType() {
        return this.type;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setType(DatabaseType type) {
        this.type = type;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public ConnectionString() {
    }

    public static class ConnectionStringBuilder {
        private DatabaseType type;
        private String catalog;
        private String schema;
        private String host;
        private Integer port;
        private String user;
        private String password;
        private String jdbcUrl;

        ConnectionStringBuilder() {
        }

        public ConnectionStringBuilder type(DatabaseType type) {
            this.type = type;
            return this;
        }

        public ConnectionStringBuilder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public ConnectionStringBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public ConnectionStringBuilder host(String host) {
            this.host = host;
            return this;
        }

        public ConnectionStringBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public ConnectionStringBuilder user(String user) {
            this.user = user;
            return this;
        }

        public ConnectionStringBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ConnectionStringBuilder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public ConnectionString build() {
            return new ConnectionString(this.type, this.catalog, this.schema, this.host, this.port, this.user, this.password, this.jdbcUrl);
        }

        public String toString() {
            return "ConnectionString.ConnectionStringBuilder(type=" + String.valueOf((Object)this.type) + ", catalog=" + this.catalog + ", schema=" + this.schema + ", host=" + this.host + ", port=" + this.port + ", user=" + this.user + ", password=" + this.password + ", jdbcUrl=" + this.jdbcUrl + ")";
        }
    }
}

