/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.permission.dto;

import com.suncode.dbexplorer.alias.permission.AccessLevel;
import com.suncode.dbexplorer.alias.permission.AccessResource;
import com.suncode.dbexplorer.alias.permission.TablesSetPermission;
import com.suncode.pwfl.administration.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.util.StringUtils;

public class TablesSetPermissionDto {
    private Long id;
    private Long tablesSet;
    private Long resourceId;
    private String resourceName;
    private AccessResource.ResourceType resourceType;
    private AccessLevel accessLevel;

    public TablesSetPermissionDto() {
    }

    public TablesSetPermissionDto(TablesSetPermission permission) {
        this.id = permission.getId();
        this.tablesSet = permission.getTablesSet().getId();
        this.accessLevel = permission.getLevel();
        AccessResource resource = permission.getResource();
        this.resourceType = resource.getType();
        if (resource.getType() == AccessResource.ResourceType.USER) {
            User user = resource.getUser();
            this.resourceId = user.getObjectId();
            this.resourceName = StringUtils.hasText((String)user.getFullName()) ? String.format("%s (%s)", user.getFullName(), user.getUserName()) : user.getUserName();
        } else if (resource.getType() == AccessResource.ResourceType.GROUP) {
            this.resourceId = resource.getGroup().getObjectId();
            this.resourceName = resource.getGroup().getName();
        }
    }

    public static List<TablesSetPermissionDto> from(Collection<TablesSetPermission> permissions) {
        ArrayList<TablesSetPermissionDto> dtos = new ArrayList<TablesSetPermissionDto>();
        for (TablesSetPermission permission : permissions) {
            dtos.add(new TablesSetPermissionDto(permission));
        }
        return dtos;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTablesSet() {
        return this.tablesSet;
    }

    public void setTablesSet(Long tablesSet) {
        this.tablesSet = tablesSet;
    }

    public Long getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public AccessResource.ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(AccessResource.ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public void setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
    }
}

