/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.permission;

import com.suncode.dbexplorer.alias.permission.AccessLevel;
import com.suncode.dbexplorer.alias.permission.AccessResource;
import com.suncode.dbexplorer.alias.permission.PermissionsService;
import com.suncode.dbexplorer.alias.permission.TablesSetPermission;
import com.suncode.dbexplorer.alias.permission.dto.TablesSetPermissionDto;
import com.suncode.dbexplorer.audit.AuditTypes;
import com.suncode.dbexplorer.context.UserContext;
import com.suncode.dbexplorer.util.authorization.AuthorizationHelper;
import com.suncode.dbexplorer.util.web.rest.RestController;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class TablesSetPermissionsController
extends RestController {
    private final PermissionsService permissionsService;
    private final AuthorizationHelper authorizationHelper;

    @RequestMapping(value={"/permissions/tablessets/{setId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TablesSetPermissionDto> get(@PathVariable Long setId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return TablesSetPermissionDto.from(this.permissionsService.getPermissions(setId));
    }

    @RequestMapping(value={"/permissions/tablessets/{setId}"}, method={RequestMethod.POST})
    @ResponseBody
    public TablesSetPermissionDto add(@PathVariable Long setId, @RequestBody TablesSetPermissionDto newPermission) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Date started = new Date();
        Long id = newPermission.getResourceId();
        AccessResource.ResourceType type = newPermission.getResourceType();
        AccessResource resource = this.permissionsService.getResource(id, type);
        TablesSetPermission permission = this.permissionsService.newPermission(setId, resource, newPermission.getAccessLevel());
        this.audit(started, AuditTypes.AUDIT_PERMISSIONS_ADD, permission);
        return new TablesSetPermissionDto(permission);
    }

    @RequestMapping(value={"/permissions/tablessets/{setId}/{permissionId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public TablesSetPermissionDto update(@PathVariable Long permissionId, @RequestBody TablesSetPermissionDto newPermission) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Date started = new Date();
        TablesSetPermission permission = this.permissionsService.changePermissionLevel(permissionId, newPermission.getAccessLevel());
        this.audit(started, AuditTypes.AUDIT_PERMISSIONS_CHANGE, permission);
        return new TablesSetPermissionDto(permission);
    }

    @RequestMapping(value={"/permissions/tablessets/{setId}/{permissionId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Void> delete(@PathVariable Long permissionId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Date started = new Date();
        TablesSetPermission permission = this.permissionsService.deletePermission(permissionId);
        this.audit(started, AuditTypes.AUDIT_PERMISSIONS_DELETE, permission);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    private void audit(Date started, AuditTypes type, TablesSetPermission permission) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("dbex.audit.tablesetname", permission.getTablesSet().getName());
        params.put("dbex.audit.permissions.accesslevel", permission.getLevel() == AccessLevel.EDIT ? "dbex.audit.permissions.accesslevel.edit" : "dbex.audit.permissions.accesslevel.view");
        if (permission.getResource().getType() == AccessResource.ResourceType.GROUP) {
            params.put("dbex.audit.permissions.resource.group", permission.getResource().getGroup().getName());
        } else {
            params.put("dbex.audit.permissions.resource.user", permission.getResource().getUser().getUserName());
        }
        ManualAuditBuilder.getInstance().type(type.getValue()).username(UserContext.userName()).success(true).params(params).started(started).stopped(new Date()).build().log();
    }

    @Autowired
    public TablesSetPermissionsController(PermissionsService permissionsService, AuthorizationHelper authorizationHelper) {
        this.permissionsService = permissionsService;
        this.authorizationHelper = authorizationHelper;
    }
}

