/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.internal;

import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.AliasService;
import com.suncode.dbexplorer.alias.exception.AliasExistsException;
import com.suncode.dbexplorer.alias.internal.AliasRepository;
import com.suncode.plugin.framework.service.Provides;
import java.util.List;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Transactional
@Provides(value={AliasService.class})
public class AliasServiceImpl
implements AliasService {
    private final AliasRepository aliasRepository;

    @Override
    public void addAlias(Alias alias) {
        Assert.notNull((Object)alias, (String)"[Assertion failed] - this argument is required; it must not be null");
        if (this.aliasRepository.findOneByProperty("name", alias.getName(), new String[0]) != null) {
            throw new AliasExistsException();
        }
        alias.setName(Jsoup.clean((String)alias.getName().trim(), (Safelist)Safelist.basic()));
        this.aliasRepository.save(alias);
    }

    @Override
    public Alias addSystemAlias() {
        if (this.aliasRepository.findOneByProperty("isSystemAlias", true, new String[0]) != null || this.aliasRepository.findOneByProperty("name", "PlusWorkflow", new String[0]) != null) {
            throw new AliasExistsException();
        }
        Alias systemAlias = Alias.createSystemAlias();
        this.aliasRepository.save(systemAlias);
        return systemAlias;
    }

    @Override
    public void deleteAlias(Long id) {
        Alias alias = this.getAlias(id);
        if (alias != null) {
            this.aliasRepository.delete(alias);
        }
    }

    @Override
    public void updateAlias(Alias alias) {
        Assert.notNull((Object)alias, (String)"[Assertion failed] - this argument is required; it must not be null");
        alias.setName(Jsoup.clean((String)alias.getName().trim(), (Safelist)Safelist.basic()));
        this.aliasRepository.update(alias);
    }

    @Override
    public Alias getAlias(Long id) {
        return (Alias)this.aliasRepository.get(id);
    }

    @Override
    public Alias getAlias(String name) {
        return (Alias)this.aliasRepository.getByField("name", name, new String[0]);
    }

    @Override
    public List<Alias> getAliases() {
        return this.aliasRepository.getAll(new String[0]);
    }

    @Override
    public List<Alias> getActiveAliases() {
        return this.getAliases().stream().filter(Alias::getIsActive).collect(Collectors.toList());
    }

    @Autowired
    public AliasServiceImpl(AliasRepository aliasRepository) {
        this.aliasRepository = aliasRepository;
    }
}

