/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Lists;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.TablesSet;
import com.suncode.dbexplorer.alias.dto.SimpleTableDto;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TablesSetDto {
    private Long id;
    private Long aliasId;
    private String name;
    private List<SimpleTableDto> tables = Lists.newArrayList();

    public TablesSetDto(Alias alias, TablesSet set) {
        this.id = set.getId();
        this.aliasId = alias.getId();
        this.name = set.getName();
        this.tables.addAll(set.getTables());
    }

    public static List<TablesSetDto> from(Alias alias) {
        return alias.getTablesSets().stream().map(set -> new TablesSetDto(alias, (TablesSet)set)).collect(Collectors.toList());
    }

    public Long getId() {
        return this.id;
    }

    public Long getAliasId() {
        return this.aliasId;
    }

    public String getName() {
        return this.name;
    }

    public List<SimpleTableDto> getTables() {
        return this.tables;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAliasId(Long aliasId) {
        this.aliasId = aliasId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTables(List<SimpleTableDto> tables) {
        this.tables = tables;
    }

    public TablesSetDto() {
    }
}

