/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.dto;

import com.google.common.collect.Lists;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.Column;
import com.suncode.dbexplorer.alias.Table;
import com.suncode.dbexplorer.alias.dto.ColumnDto;
import com.suncode.dbexplorer.alias.dto.PrimaryKeyDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TableDto {
    private Long aliasId;
    private String schema;
    private String name;
    private boolean view;
    private String displayName;
    private Boolean logging;
    private PrimaryKeyDto primaryKey;
    private List<ColumnDto> columns = Lists.newArrayList();

    public TableDto() {
    }

    public TableDto(Alias alias, Table table) {
        this.aliasId = alias.getId();
        this.schema = table.getTableSchema().getSchema();
        this.name = table.getName();
        this.view = table.isView();
        this.displayName = table.getDisplayName();
        this.logging = table.getLogging();
        if (table.getTableSchema().hasPrimaryKey()) {
            this.primaryKey = new PrimaryKeyDto(table.getPrimaryKey());
        }
        for (Column column : table.getColumns()) {
            this.columns.add(new ColumnDto(alias, table, column));
        }
    }

    public static List<TableDto> from(Alias alias, Set<Table> tables) {
        ArrayList<TableDto> dtos = new ArrayList<TableDto>();
        for (Table table : tables) {
            dtos.add(new TableDto(alias, table));
        }
        return dtos;
    }

    public void setAliasId(Long aliasId) {
        this.aliasId = aliasId;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setView(boolean view) {
        this.view = view;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setLogging(Boolean logging) {
        this.logging = logging;
    }

    public void setPrimaryKey(PrimaryKeyDto primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setColumns(List<ColumnDto> columns) {
        this.columns = columns;
    }

    public Long getAliasId() {
        return this.aliasId;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public boolean isView() {
        return this.view;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Boolean getLogging() {
        return this.logging;
    }

    public PrimaryKeyDto getPrimaryKey() {
        return this.primaryKey;
    }

    public List<ColumnDto> getColumns() {
        return this.columns;
    }
}

