/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.DatabaseType;

public class AliasDto {
    private Long id;
    private String name;
    private String catalog;
    private DatabaseType type;
    private String host;
    private Integer port;
    private String jdbcUrl;
    private String user;
    private String password;
    private Boolean isSystemAlias;
    private Boolean isActive;
    private String displayedName;
    private Boolean logging;
    private Boolean isJdbcUrlConfig;

    public AliasDto(Alias alias) {
        this.id = alias.getId();
        this.name = alias.getName();
        this.isSystemAlias = alias.getIsSystemAlias();
        this.isActive = alias.getIsActive();
        this.logging = alias.getLogging();
        this.isJdbcUrlConfig = alias.getIsJdbcUrlConfig();
        ConnectionString connection = alias.getWrappedConnectionString();
        this.catalog = connection.getCatalog();
        this.host = connection.getHost();
        this.port = connection.getPort();
        this.user = connection.getUser();
        this.password = connection.getPassword();
        this.type = connection.getType();
        this.jdbcUrl = connection.getJdbcUrl();
    }

    public static AliasDto from(Alias alias) {
        return new AliasDto(alias);
    }

    @JsonIgnore
    public ConnectionString getConnectionString() {
        return ConnectionString.builder().type(this.type).catalog(this.catalog).host(this.host).port(this.port).user(this.user).password(this.password).jdbcUrl(this.jdbcUrl).build();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public DatabaseType getType() {
        return this.type;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean getIsSystemAlias() {
        return this.isSystemAlias;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public String getDisplayedName() {
        return this.displayedName;
    }

    public Boolean getLogging() {
        return this.logging;
    }

    public Boolean getIsJdbcUrlConfig() {
        return this.isJdbcUrlConfig;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setType(DatabaseType type) {
        this.type = type;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setIsSystemAlias(Boolean isSystemAlias) {
        this.isSystemAlias = isSystemAlias;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public void setDisplayedName(String displayedName) {
        this.displayedName = displayedName;
    }

    public void setLogging(Boolean logging) {
        this.logging = logging;
    }

    public void setIsJdbcUrlConfig(Boolean isJdbcUrlConfig) {
        this.isJdbcUrlConfig = isJdbcUrlConfig;
    }

    public AliasDto() {
    }
}

