/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.data;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.AliasService;
import com.suncode.dbexplorer.alias.Table;
import com.suncode.dbexplorer.alias.data.DataService;
import com.suncode.dbexplorer.alias.data.Filter;
import com.suncode.dbexplorer.alias.data.UpdateRecord;
import com.suncode.dbexplorer.alias.data.dto.SecuredTablesSetDto;
import com.suncode.dbexplorer.alias.data.util.importer.ImportHelper;
import com.suncode.dbexplorer.alias.data.util.importer.config.ImportType;
import com.suncode.dbexplorer.alias.exception.AliasNotActiveException;
import com.suncode.dbexplorer.alias.permission.AccessLevel;
import com.suncode.dbexplorer.alias.permission.PermissionsService;
import com.suncode.dbexplorer.alias.permission.SecuredTablesSet;
import com.suncode.dbexplorer.audit.AuditTypes;
import com.suncode.dbexplorer.context.UserContext;
import com.suncode.dbexplorer.database.DatabaseFactory;
import com.suncode.dbexplorer.database.Record;
import com.suncode.dbexplorer.database.query.Page;
import com.suncode.dbexplorer.database.query.Pagination;
import com.suncode.dbexplorer.util.authorization.AuthorizationHelper;
import com.suncode.dbexplorer.util.web.Paging;
import com.suncode.dbexplorer.util.web.rest.ResourceNotFoundException;
import com.suncode.dbexplorer.util.web.rest.RestController;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import com.suncode.pwfl.util.TempFile;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.support.io.DownloadResource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class DataController
extends RestController {
    private static final Logger log = LoggerFactory.getLogger(DataController.class);
    private final DatabaseFactory databaseFactory;
    private final PermissionsService permissionService;
    private final DataService dataService;
    private final AliasService aliasService;
    private final AuthorizationHelper authorizationHelper;
    private static final ConcurrentMap<UUID, NamedFile> oneTimeFiles = new ConcurrentHashMap<UUID, NamedFile>();
    private final ImportHelper importHelper;

    @RequestMapping(value={"/data/tablessets"}, method={RequestMethod.GET})
    @ResponseBody
    public List<SecuredTablesSetDto> getTablesSets() {
        List<SecuredTablesSet> sets = this.permissionService.getSecuredTablesSets(UserContext.userName()).stream().filter(securedTablesSet -> securedTablesSet.getSet().getAlias().getIsActive()).collect(Collectors.toList());
        if (sets.size() == 0) {
            return new ArrayList<SecuredTablesSetDto>();
        }
        return SecuredTablesSetDto.from(this.databaseFactory, sets);
    }

    @RequestMapping(value={"/aliases/{aliasId}/data"}, method={RequestMethod.GET})
    @ResponseBody
    public Page<Record> getData(@PathVariable Long aliasId, @RequestParam String schema, @RequestParam String table, @RequestParam Long limit, Paging paging, @RequestParam(required=false) String filters) throws Exception {
        this.authorizationHelper.hasAccessToTable(UserContext.userName(), table, AccessLevel.VIEW);
        this.validateAliasIsActive(aliasId);
        if (filters == null) {
            filters = "[]";
        }
        ObjectMapper objectMapper = new ObjectMapper();
        List filters2 = (List)objectMapper.readValue(filters, (TypeReference)new TypeReference<List<Filter>>(){});
        Pagination pagination = paging.pagination();
        if (limit != null) {
            pagination.setPageSize(limit.intValue());
        }
        return this.dataService.getPage(aliasId, schema, table, pagination, filters2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/aliases/{aliasId}/data"}, method={RequestMethod.POST})
    @ResponseBody
    public void insertData(@PathVariable Long aliasId, @RequestParam String schema, @RequestParam String table, @RequestBody UpdateRecord updateRecord) {
        this.authorizationHelper.hasAccessToTable(UserContext.userName(), table, AccessLevel.EDIT);
        boolean isSuccess = false;
        Date start = new Date();
        this.validateAliasIsActive(aliasId);
        Alias alias = this.aliasService.getAlias(aliasId);
        Table aliasTable = alias.getTable(schema, table, this.databaseFactory);
        updateRecord.setSchema(schema);
        updateRecord.setTable(table);
        try {
            this.dataService.addRecord(aliasId, updateRecord);
            isSuccess = true;
            if (!alias.getLogging().booleanValue() && !aliasTable.getLogging()) return;
        }
        catch (Throwable throwable) {
            if (!alias.getLogging().booleanValue() && !aliasTable.getLogging()) throw throwable;
            log.info(String.format("Data insertion in alias: %s, schema: %s, table: %s, record: %s", alias.getName(), schema, table, updateRecord.getData().toString()));
            Map<String, Object> auditParams = this.prepareBaseParams(alias, aliasTable);
            auditParams.put("dbex.audit.alias.table.record.value", updateRecord.getData().toString().replace("=", "->"));
            this.logAudit(AuditTypes.AUDIT_TABLE_ROW_INSERT, isSuccess, auditParams, start);
            throw throwable;
        }
        log.info(String.format("Data insertion in alias: %s, schema: %s, table: %s, record: %s", alias.getName(), schema, table, updateRecord.getData().toString()));
        Map<String, Object> auditParams = this.prepareBaseParams(alias, aliasTable);
        auditParams.put("dbex.audit.alias.table.record.value", updateRecord.getData().toString().replace("=", "->"));
        this.logAudit(AuditTypes.AUDIT_TABLE_ROW_INSERT, isSuccess, auditParams, start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/aliases/{aliasId}/data"}, method={RequestMethod.PUT})
    @ResponseBody
    public void updateData(@PathVariable Long aliasId, @RequestParam String schema, @RequestParam String table, @RequestBody UpdateRecord updateRecord) {
        block3: {
            String key;
            this.authorizationHelper.hasAccessToTable(UserContext.userName(), table, AccessLevel.EDIT);
            Date start = new Date();
            boolean isSuccess = false;
            this.validateAliasIsActive(aliasId);
            Alias alias = this.aliasService.getAlias(aliasId);
            Table aliasTable = alias.getTable(schema, table, this.databaseFactory);
            updateRecord.setSchema(schema);
            updateRecord.setTable(table);
            Optional<Record> recordToUpdate = Optional.ofNullable(this.dataService.getRecord(alias, updateRecord));
            try {
                this.dataService.updateRecord(aliasId, updateRecord);
                isSuccess = true;
                if (!alias.getLogging().booleanValue() && !aliasTable.getLogging()) break block3;
                key = updateRecord.getData().keySet().iterator().next();
            }
            catch (Throwable throwable) {
                if (alias.getLogging().booleanValue() || aliasTable.getLogging()) {
                    String key2 = updateRecord.getData().keySet().iterator().next();
                    String oldValue = String.valueOf(recordToUpdate.map(record -> record.getData().getOrDefault(key2, "N/A")).orElse("N/A"));
                    String newValue = String.valueOf(updateRecord.getData().getOrDefault(key2, "N/A"));
                    log.info(String.format("Data update in alias: %s, schema: %s, table: %s, column: %s, value: %s -> %s", alias.getName(), aliasTable.getSchema(), aliasTable.getName(), key2, oldValue, newValue));
                    Map<String, Object> params = this.prepareBaseParams(alias, aliasTable);
                    params.put("dbex.audit.alias.column.columnName", key2);
                    params.put("dbex.audit.alias.table.record.value", String.format("%s -> %s", oldValue, newValue));
                    this.logAudit(AuditTypes.AUDIT_TABLE_ROW_UPDATE, isSuccess, params, start);
                }
                throw throwable;
            }
            String oldValue = String.valueOf(recordToUpdate.map(record -> record.getData().getOrDefault(key2, "N/A")).orElse("N/A"));
            String newValue = String.valueOf(updateRecord.getData().getOrDefault(key, "N/A"));
            log.info(String.format("Data update in alias: %s, schema: %s, table: %s, column: %s, value: %s -> %s", alias.getName(), aliasTable.getSchema(), aliasTable.getName(), key, oldValue, newValue));
            Map<String, Object> params = this.prepareBaseParams(alias, aliasTable);
            params.put("dbex.audit.alias.column.columnName", key);
            params.put("dbex.audit.alias.table.record.value", String.format("%s -> %s", oldValue, newValue));
            this.logAudit(AuditTypes.AUDIT_TABLE_ROW_UPDATE, isSuccess, params, start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/aliases/{aliasId}/data"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteData(@PathVariable Long aliasId, @RequestParam String schema, @RequestParam String table, @RequestBody UpdateRecord updateRecord) {
        this.authorizationHelper.hasAccessToTable(UserContext.userName(), table, AccessLevel.EDIT);
        boolean isSuccess = false;
        Date start = new Date();
        this.validateAliasIsActive(aliasId);
        Alias alias = this.aliasService.getAlias(aliasId);
        Table aliasTable = alias.getTable(schema, table, this.databaseFactory);
        updateRecord.setSchema(schema);
        updateRecord.setTable(table);
        try {
            this.dataService.deleteRecord(aliasId, updateRecord);
            isSuccess = true;
            if (!alias.getLogging().booleanValue() && !aliasTable.getLogging()) return;
        }
        catch (Throwable throwable) {
            if (!alias.getLogging().booleanValue() && !aliasTable.getLogging()) throw throwable;
            log.info(String.format("Data deletion in alias: %s, schema: %s, table: %s, record id: %s", alias.getName(), schema, table, updateRecord.getPrimaryKey().values().iterator().next()));
            Map<String, Object> params = this.prepareBaseParams(alias, aliasTable);
            params.put("dbex.audit.alias.id", updateRecord.getPrimaryKey().values().iterator().next());
            this.logAudit(AuditTypes.AUDIT_TABLE_ROW_DELETE, isSuccess, params, start);
            throw throwable;
        }
        log.info(String.format("Data deletion in alias: %s, schema: %s, table: %s, record id: %s", alias.getName(), schema, table, updateRecord.getPrimaryKey().values().iterator().next()));
        Map<String, Object> params = this.prepareBaseParams(alias, aliasTable);
        params.put("dbex.audit.alias.id", updateRecord.getPrimaryKey().values().iterator().next());
        this.logAudit(AuditTypes.AUDIT_TABLE_ROW_DELETE, isSuccess, params, start);
    }

    @RequestMapping(value={"/aliases/{aliasId}/deletedata"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteData(@PathVariable Long aliasId, @RequestBody List<UpdateRecord> updateRecords) {
        boolean hasRecordsFromDifferentSchemas;
        if (updateRecords.isEmpty()) {
            return;
        }
        boolean hasRecordsFromDifferentTables = updateRecords.stream().collect(Collectors.groupingBy(UpdateRecord::getTable)).keySet().size() != 1;
        boolean bl = hasRecordsFromDifferentSchemas = updateRecords.stream().collect(Collectors.groupingBy(UpdateRecord::getSchema)).keySet().size() != 1;
        if (hasRecordsFromDifferentTables || hasRecordsFromDifferentSchemas) {
            Translator translator = Translators.get(DataController.class);
            throw new ServiceException(translator.getMessage("dbex.validation.bulk.delete.error"));
        }
        this.authorizationHelper.hasAccessToTable(UserContext.userName(), updateRecords.get(0).getTable(), AccessLevel.EDIT);
        this.validateAliasIsActive(aliasId);
        this.dataService.deleteRecords(aliasId, updateRecords);
    }

    @RequestMapping(value={"/aliases/{aliasId}/data/import/validate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> validateColumnsMatch(@PathVariable Long aliasId, @RequestParam MultipartFile file, @RequestParam String schema, @RequestParam String table) throws IOException {
        List<String> uniqueColumns;
        this.authorizationHelper.hasAccessToTable(UserContext.userName(), table, AccessLevel.EDIT);
        this.validateAliasIsActive(aliasId);
        try (InputStream fileStream = file.getInputStream();){
            uniqueColumns = this.dataService.getUniqueColumnsForFileAndTable(aliasId, schema, table, this.importHelper.readColumns(fileStream));
        }
        if (uniqueColumns.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)uniqueColumns.stream().map(StringUtils::stripAccents).collect(Collectors.joining(", ")), (HttpStatusCode)HttpStatus.EXPECTATION_FAILED);
    }

    @RequestMapping(value={"/aliases/{aliasId}/data/import"}, method={RequestMethod.POST})
    @ResponseBody
    public void importTable(@PathVariable Long aliasId, @RequestParam MultipartFile file, @RequestParam String schema, @RequestParam String table, @RequestParam(required=false, defaultValue="false") boolean clear, @RequestParam(required=false, defaultValue="STANDARD") ImportType importType) throws IOException {
        this.authorizationHelper.hasAccessToTable(UserContext.userName(), table, AccessLevel.EDIT);
        this.validateAliasIsActive(aliasId);
        Date started = new Date();
        Alias alias = this.aliasService.getAlias(aliasId);
        Table aliasTable = alias.getTable(schema, table, this.databaseFactory);
        Map<String, Object> auditParams = this.prepareBaseParams(alias, aliasTable);
        try {
            this.dataService.importTable(aliasId, schema, table, Boolean.TRUE.equals(clear), () -> ((MultipartFile)file).getInputStream(), importType);
            this.logAudit(AuditTypes.AUDIT_TABLE_IMPORT, true, auditParams, started);
        }
        catch (Exception e) {
            this.logAudit(AuditTypes.AUDIT_TABLE_IMPORT, false, auditParams, started);
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/aliases/{aliasId}/data/export"}, method={RequestMethod.GET})
    @ResponseBody
    public String exportTable(@PathVariable Long aliasId, @RequestParam String schema, @RequestParam String table, @RequestParam String filename, Paging paging, @RequestParam(required=false) String filters) throws IOException {
        SXSSFWorkbook workbook;
        this.authorizationHelper.hasAccessToTable(UserContext.userName(), table, AccessLevel.VIEW);
        this.validateAliasIsActive(aliasId);
        Date started = new Date();
        Alias alias = this.aliasService.getAlias(aliasId);
        Table aliasTable = alias.getTable(schema, table, this.databaseFactory);
        if (filters == null) {
            filters = "[]";
        }
        ObjectMapper objectMapper = new ObjectMapper();
        List filters2 = (List)objectMapper.readValue(filters, (TypeReference)new TypeReference<List<Filter>>(){});
        try {
            workbook = this.dataService.exportTable(aliasId, schema, table, paging.pagination(), filters2);
        }
        catch (Exception e) {
            log.info(e.toString());
            Throwable cause = e.getCause();
            throw new ServiceException(cause != null ? cause.getLocalizedMessage() : e.getLocalizedMessage(), (Throwable)e);
        }
        TempFile tempFile = new TempFile();
        tempFile.getFile().deleteOnExit();
        try (FileOutputStream fs = new FileOutputStream(tempFile.getFile());){
            workbook.write((OutputStream)fs);
        }
        UUID id = UUID.randomUUID();
        oneTimeFiles.put(id, new NamedFile(filename, tempFile));
        Map<String, Object> auditParams = this.prepareBaseParams(alias, aliasTable);
        auditParams.put("dbex.audit.alias.table.export.filters", filters);
        this.logAudit(AuditTypes.AUDIT_TABLE_EXPORT, true, auditParams, started);
        return id.toString();
    }

    private void validateAliasIsActive(Long aliasId) {
        Alias alias = this.aliasService.getAlias(aliasId);
        if (!alias.getIsActive().booleanValue()) {
            Translator translator = Translators.get(DataController.class);
            throw new AliasNotActiveException(translator.getMessage("dbex.alias.notActive.exception", new Object[]{alias.getName()}));
        }
    }

    @RequestMapping(value={"/download/{uuid}"}, method={RequestMethod.GET})
    @ResponseBody
    public DownloadResource download(@PathVariable String uuid) throws IOException {
        UUID id = UUID.fromString(uuid);
        NamedFile namedFile = (NamedFile)oneTimeFiles.remove(id);
        if (namedFile == null) {
            throw new ResourceNotFoundException();
        }
        byte[] file = FileUtils.readFileToByteArray((File)namedFile.file.getFile());
        namedFile.file.delete();
        ByteArrayResource resource = new ByteArrayResource(file);
        return new DownloadResource(namedFile.name, resource.contentLength(), (Resource)resource);
    }

    @ResponseBody
    @ExceptionHandler(value={AliasNotActiveException.class})
    public ResponseEntity<?> handleBadRequest(Exception e) {
        return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ResponseBody
    @ExceptionHandler(value={ServiceException.class})
    public ResponseEntity<?> handleServiceException(ServiceException e) {
        return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.EXPECTATION_FAILED);
    }

    private Map<String, Object> prepareBaseParams(Alias alias, Table aliasTable) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("dbex.audit.alias.name", alias.getName());
        String displayName = aliasTable.getDisplayName();
        String tableName = displayName != null ? String.format("%s (%s)", aliasTable.getName(), displayName) : aliasTable.getName();
        params.put("dbex.audit.alias.table.tableName", tableName);
        return params;
    }

    private void logAudit(AuditTypes type, boolean success, Map<String, Object> auditParams, Date start) {
        ManualAuditBuilder.getInstance().type(type.getValue()).username(UserContext.userName()).success(success).params(auditParams).started(start).stopped(new Date()).build().log();
    }

    @Autowired
    public DataController(DatabaseFactory databaseFactory, PermissionsService permissionService, DataService dataService, AliasService aliasService, AuthorizationHelper authorizationHelper, ImportHelper importHelper) {
        this.databaseFactory = databaseFactory;
        this.permissionService = permissionService;
        this.dataService = dataService;
        this.aliasService = aliasService;
        this.authorizationHelper = authorizationHelper;
        this.importHelper = importHelper;
    }

    private static class NamedFile {
        private final String name;
        private final TempFile file;

        public NamedFile(String name, TempFile file) {
            this.name = name;
            this.file = file;
        }
    }
}

