/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias;

import com.google.common.collect.Sets;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.dto.SimpleTableDto;
import com.suncode.dbexplorer.alias.permission.TablesSetPermission;
import com.suncode.dbexplorer.util.persistence.BaseEntity;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.Collection;
import java.util.Set;
import org.springframework.util.Assert;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
public class TablesSet
extends BaseEntity {
    @ManyToOne(optional=false)
    @JoinColumn(name="alias", nullable=false)
    private Alias alias;
    @Column(nullable=false)
    private String name;
    @AttributeOverrides(value={@AttributeOverride(name="name", column=@Column(name="tables"))})
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="tables_set_tables", joinColumns={@JoinColumn(name="tables_set")})
    private Set<SimpleTableDto> tables = Sets.newLinkedHashSet();
    @OneToMany(mappedBy="tablesSet", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    private Set<TablesSetPermission> permissions = Sets.newHashSet();

    private TablesSet() {
    }

    public TablesSet(String name) {
        this(name, null);
    }

    public TablesSet(String name, Collection<SimpleTableDto> tables) {
        Assert.hasText((String)name, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        this.name = name;
        if (tables != null) {
            this.tables.addAll(tables);
        }
    }

    public Alias getAlias() {
        return this.alias;
    }

    void setAlias(Alias alias) {
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<SimpleTableDto> getTables() {
        return this.tables;
    }

    public void setTablesNames(Collection<SimpleTableDto> tables) {
        this.tables.clear();
        this.tables.addAll(tables);
    }

    public Set<TablesSetPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<TablesSetPermission> permissions) {
        this.permissions = permissions;
    }
}

