/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias;

import com.google.common.collect.Maps;
import com.suncode.dbexplorer.alias.Column;
import com.suncode.dbexplorer.alias.settings.TableSettings;
import com.suncode.dbexplorer.database.schema.ColumnSchema;
import com.suncode.dbexplorer.database.schema.PrimaryKey;
import com.suncode.dbexplorer.database.schema.TableSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public class Table {
    private final TableSchema table;
    private final TableSettings settings;
    private final Map<String, Column> columns = Maps.newLinkedHashMap();

    public Table(TableSchema table, TableSettings settings) {
        Assert.notNull((Object)table, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull((Object)settings, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.state((boolean)table.getName().equals(settings.getTableName()), (String)"[Assertion failed] - this state invariant must be true");
        this.table = table;
        this.settings = settings;
        for (ColumnSchema column : table.getColumns()) {
            Column col = new Column(column, settings.getColumnSettings(column.getName()));
            this.columns.put(column.getName(), col);
        }
    }

    public TableSchema getTableSchema() {
        return this.table;
    }

    public String getSchema() {
        return this.table.getSchema();
    }

    public String getName() {
        return this.table.getName();
    }

    public boolean isView() {
        return this.table.isView();
    }

    public String getDisplayName() {
        return this.settings.getDisplayName();
    }

    public boolean getLogging() {
        return this.settings.isLogging();
    }

    public PrimaryKey getPrimaryKey() {
        return this.table.getPrimaryKey();
    }

    public List<Column> getColumns() {
        return new ArrayList<Column>(this.columns.values());
    }
}

