/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias;

import com.google.common.collect.Sets;
import com.suncode.dbexplorer.alias.Schema;
import com.suncode.dbexplorer.alias.Table;
import com.suncode.dbexplorer.alias.TablesSet;
import com.suncode.dbexplorer.alias.settings.Settings;
import com.suncode.dbexplorer.alias.settings.TableSettings;
import com.suncode.dbexplorer.alias.util.SystemConnectionStringResolver;
import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.ConnectionStringDomain;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseFactory;
import com.suncode.dbexplorer.database.schema.DatabaseSchema;
import com.suncode.dbexplorer.database.schema.TableSchema;
import com.suncode.dbexplorer.util.persistence.BaseEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.Assert;

@Entity
public class Alias
extends BaseEntity {
    public static final String SYSTEM_ALIAS_NAME = "PlusWorkflow";
    @Column(nullable=false, unique=true)
    private String name;
    @Embedded
    private ConnectionStringDomain connectionStringDomain;
    @Embedded
    private Settings settings = new Settings();
    @Column(nullable=false)
    private Boolean isSystemAlias;
    @Column(nullable=false)
    private Boolean isActive;
    @Column(nullable=false)
    private Boolean logging;
    @Column(nullable=false, name="is_jdbc_url_config")
    private Boolean isJdbcUrlConfig;
    @OneToMany(mappedBy="alias", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<TablesSet> tablesSets = Sets.newHashSet();

    public Alias(String name, ConnectionStringDomain connectionStringDomain) {
        Assert.hasText((String)name, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        Assert.notNull((Object)connectionStringDomain, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.name = name;
        this.connectionStringDomain = connectionStringDomain;
        this.isSystemAlias = false;
    }

    public static Alias createSystemAlias() {
        Alias systemAlias = new Alias();
        systemAlias.setName(SYSTEM_ALIAS_NAME);
        systemAlias.setIsSystemAlias(true);
        systemAlias.setIsJdbcUrlConfig(false);
        systemAlias.setIsActive(true);
        systemAlias.setLogging(true);
        return systemAlias;
    }

    public void setName(String name) {
        Assert.hasText((String)name, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        this.name = name;
    }

    public void setConnectionStringDomain(ConnectionStringDomain connectionStringDomain) {
        Assert.notNull((Object)connectionStringDomain, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.connectionStringDomain = connectionStringDomain;
    }

    public Settings getSettings() {
        if (this.settings == null) {
            this.settings = new Settings();
        }
        return this.settings;
    }

    public void addTablesSet(TablesSet set) {
        Assert.notNull((Object)set, (String)"[Assertion failed] - this argument is required; it must not be null");
        set.setAlias(this);
        this.tablesSets.add(set);
    }

    public void removeTablesSet(TablesSet set) {
        Assert.notNull((Object)set, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.tablesSets.remove(set);
    }

    public Set<TablesSet> getTablesSets() {
        return Collections.unmodifiableSet(this.tablesSets);
    }

    public TablesSet getTablesSet(Long id) {
        for (TablesSet set : this.tablesSets) {
            if (!set.getId().equals(id)) continue;
            return set;
        }
        return null;
    }

    public Set<Table> getTables(DatabaseFactory databaseFactory) {
        Database database = databaseFactory.create(this.getWrappedConnectionString());
        LinkedHashSet tables = Sets.newLinkedHashSet();
        for (DatabaseSchema databaseSchema : database.getSchemas()) {
            for (TableSchema tableSchema : databaseSchema.getTables().values()) {
                String schemaName = tableSchema.getSchema();
                String tableName = tableSchema.getName();
                TableSettings tableSettings = this.settings.getTableSettings(schemaName, tableName);
                Table table = new Table(tableSchema, tableSettings);
                tables.add(table);
            }
        }
        return tables;
    }

    public Set<Schema> getSchemas(DatabaseFactory databaseFactory) {
        Database database = databaseFactory.create(this.getWrappedConnectionString());
        LinkedHashSet schemas = Sets.newLinkedHashSet();
        for (DatabaseSchema databaseSchema : database.getSchemas()) {
            LinkedHashSet tables = Sets.newLinkedHashSet();
            for (TableSchema tableSchema : databaseSchema.getTables().values()) {
                String schemaName = tableSchema.getSchema();
                String tableName = tableSchema.getName();
                TableSettings tableSettings = this.settings.getTableSettings(schemaName, tableName);
                Table table = new Table(tableSchema, tableSettings);
                tables.add(table);
            }
            schemas.add(new Schema(databaseSchema.getName(), tables));
        }
        return schemas;
    }

    public Table getTable(String schema, String tableName, DatabaseFactory databaseFactory) {
        for (Table table : this.getTables(databaseFactory)) {
            if (!table.getSchema().equals(schema) || !table.getName().equals(tableName)) continue;
            return table;
        }
        return null;
    }

    public ConnectionString getWrappedConnectionString() {
        if (this.isSystemAlias.booleanValue()) {
            return SystemConnectionStringResolver.getSystemConnectionString();
        }
        if (this.isJdbcUrlConfig.booleanValue()) {
            return ConnectionString.fromJdbcUrl(this.connectionStringDomain);
        }
        return ConnectionString.fromDomain(this.connectionStringDomain);
    }

    private Alias() {
    }

    public String getName() {
        return this.name;
    }

    public ConnectionStringDomain getConnectionStringDomain() {
        return this.connectionStringDomain;
    }

    public Boolean getIsSystemAlias() {
        return this.isSystemAlias;
    }

    public void setIsSystemAlias(Boolean isSystemAlias) {
        this.isSystemAlias = isSystemAlias;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public Boolean getLogging() {
        return this.logging;
    }

    public void setLogging(Boolean logging) {
        this.logging = logging;
    }

    public Boolean getIsJdbcUrlConfig() {
        return this.isJdbcUrlConfig;
    }

    public void setIsJdbcUrlConfig(Boolean isJdbcUrlConfig) {
        this.isJdbcUrlConfig = isJdbcUrlConfig;
    }
}

