/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.schema;

import com.google.common.collect.Maps;
import com.suncode.dbexplorer.database.schema.Sequence;
import com.suncode.dbexplorer.database.schema.TableSchema;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DatabaseSchema {
    private final String name;
    private final Map<String, TableSchema> tables = Maps.newLinkedHashMap();
    private final Map<String, Sequence> sequences = Maps.newLinkedHashMap();

    public DatabaseSchema(String name, List<TableSchema> tables, List<Sequence> sequences) {
        this.name = name;
        for (TableSchema table : tables) {
            this.tables.put(table.getName(), table);
        }
        for (Sequence sequence : sequences) {
            this.sequences.put(sequence.getName(), sequence);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean tableExists(String name) {
        return this.tables.containsKey(name);
    }

    public TableSchema getTable(String name) {
        TableSchema table = this.tables.get(name);
        if (table == null) {
            throw new IllegalArgumentException("Table [" + name + "] not found in " + this.name + " schema");
        }
        return table;
    }

    public Map<String, TableSchema> getTables() {
        return Collections.unmodifiableMap(this.tables);
    }

    public Map<String, Sequence> getSequences() {
        return Collections.unmodifiableMap(this.sequences);
    }
}

