/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.query;

import com.suncode.dbexplorer.database.query.Condition;
import com.suncode.dbexplorer.database.query.QueryContext;
import com.suncode.dbexplorer.database.query.QueryParameter;
import com.suncode.dbexplorer.database.type.DataType;
import org.springframework.util.Assert;

public class LikeCondition
implements Condition {
    private final String column;
    private String value;
    private boolean caseSensitive;

    public LikeCondition(String column, String value, boolean caseSensitive) {
        Assert.notNull((Object)value, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.column = column;
        this.value = value;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public String toSql(QueryContext queryContext) {
        String alias = queryContext.getColumnAlias(this.column);
        StringBuilder sql = new StringBuilder();
        if (!this.caseSensitive) {
            this.value = this.value.toUpperCase();
            sql.append("UPPER(").append(alias).append(")");
        } else {
            sql.append(alias);
        }
        sql.append(" LIKE ").append("?");
        return sql.toString();
    }

    @Override
    public QueryParameter[] getParameters(QueryContext queryContext) {
        DataType type = queryContext.getTypeOf(this.column);
        return new QueryParameter[]{new QueryParameter(this.value, type)};
    }
}

