/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.type;

import com.suncode.dbexplorer.database.internal.type.HibernateDataTypeHandler;
import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.dbexplorer.database.type.FloatDataType;
import com.suncode.dbexplorer.database.type.NativeType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.util.NumberUtils;

public class FloatDataTypeHandler
extends HibernateDataTypeHandler {
    @Override
    public DataType create(NativeType nativeType) {
        return new FloatDataType(nativeType);
    }

    @Override
    protected Object convert(Object value, Class<?> targetClass, DataType dataType) {
        if (value instanceof Number) {
            return NumberUtils.convertNumberToTargetClass((Number)((Number)value), targetClass);
        }
        if (value instanceof String) {
            return NumberUtils.parseNumber((String)((String)value), targetClass);
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected Type resolveHibernateType(DataType dataType) {
        int sqlType = dataType.getNativeType().getSqlType();
        switch (sqlType) {
            case 2: 
            case 3: {
                return StandardBasicTypes.BIG_DECIMAL;
            }
            case 8: {
                return StandardBasicTypes.DOUBLE;
            }
            case 6: {
                return StandardBasicTypes.FLOAT;
            }
            case 7: {
                return StandardBasicTypes.FLOAT;
            }
        }
        throw new IllegalStateException();
    }
}

