/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.schema.jdbc;

import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.internal.schema.SchemaLoader;
import com.suncode.dbexplorer.database.internal.schema.jdbc.ColumnData;
import com.suncode.dbexplorer.database.internal.schema.jdbc.PrimaryKeyData;
import com.suncode.dbexplorer.database.internal.schema.jdbc.TableData;
import com.suncode.dbexplorer.database.internal.support.ResultSetMapper;
import com.suncode.dbexplorer.database.internal.type.DataTypeRegistry;
import com.suncode.dbexplorer.database.schema.ColumnSchema;
import com.suncode.dbexplorer.database.schema.DatabaseSchema;
import com.suncode.dbexplorer.database.schema.PrimaryKey;
import com.suncode.dbexplorer.database.schema.Sequence;
import com.suncode.dbexplorer.database.schema.TableSchema;
import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.dbexplorer.database.type.NativeType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class JdbcSchemaLoader
implements SchemaLoader {
    private static final Logger log = LoggerFactory.getLogger(JdbcSchemaLoader.class);
    private final DataTypeRegistry dataTypeRegistry;

    protected JdbcSchemaLoader(DataTypeRegistry dataTypeRegistry) {
        Assert.notNull((Object)dataTypeRegistry, (String)"DateTypeRegistry cannot be null");
        this.dataTypeRegistry = dataTypeRegistry;
    }

    protected abstract List<Sequence> readSequences(DatabaseSession var1, String var2);

    protected List<TableSchema> readTables(DatabaseSession session, String schemaName) throws SQLException {
        String catalog = session.getDatabase().getCatalog();
        Connection connection = session.getConnection();
        List<TableData> tablesData = this.readTablesData(catalog, schemaName, connection.getMetaData());
        LinkedList<TableSchema> tables = new LinkedList<TableSchema>();
        for (TableData tableData : tablesData) {
            boolean isView = "VIEW".equalsIgnoreCase(tableData.getType());
            PrimaryKey primaryKey = this.readPrimaryKey(tableData.getName(), catalog, schemaName, connection.getMetaData());
            List<ColumnSchema> columns = this.readColumns(tableData.getName(), catalog, schemaName, connection.getMetaData());
            TableSchema table = new TableSchema(schemaName, tableData.getName(), isView, columns, primaryKey);
            tables.add(table);
        }
        return tables;
    }

    @Override
    public List<DatabaseSchema> loadSchemas(DatabaseSession session, List<String> schemasNames) throws Exception {
        LinkedList<DatabaseSchema> result = new LinkedList<DatabaseSchema>();
        for (String schemaName : schemasNames) {
            List<TableSchema> tables = this.readTables(session, schemaName);
            result.add(new DatabaseSchema(schemaName, tables, this.readSequences(session, schemaName)));
        }
        return result;
    }

    protected List<TableData> readTablesData(String catalog, String schema, DatabaseMetaData metaData) throws SQLException {
        return ResultSetMapper.map(metaData.getTables(catalog, schema, null, new String[]{"TABLE", "VIEW"})).mapString("TABLE_NAME", "name").mapString("TABLE_TYPE", "type").beans(TableData.class);
    }

    protected PrimaryKey readPrimaryKey(String tableName, String catalog, String schema, DatabaseMetaData metaData) throws SQLException {
        boolean createdFromIndexes = false;
        List<PrimaryKeyData> pkData = ResultSetMapper.map(metaData.getPrimaryKeys(catalog, schema, tableName)).mapString("PK_NAME", "name").mapString("COLUMN_NAME", "columnName").beans(PrimaryKeyData.class);
        if (pkData.isEmpty()) {
            pkData = this.getUniqueIndicesData(catalog, tableName, schema, metaData);
            if (pkData.isEmpty()) {
                return null;
            }
            createdFromIndexes = true;
        }
        String pkName = null;
        HashSet<String> columns = new HashSet<String>();
        for (PrimaryKeyData pk : pkData) {
            if (pkName == null) {
                pkName = pk.getName();
            }
            columns.add(pk.getColumnName());
        }
        return new PrimaryKey(pkName, columns, createdFromIndexes);
    }

    protected List<PrimaryKeyData> getUniqueIndicesData(String catalog, String tableName, String schema, DatabaseMetaData metaData) {
        try {
            return ResultSetMapper.map(metaData.getIndexInfo(catalog, schema, tableName, true, false)).mapString("INDEX_NAME", "name").mapString("COLUMN_NAME", "columnName").beans(PrimaryKeyData.class).stream().filter(primaryKeyData -> primaryKeyData.getName() != null).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.info("Exception occurred while fetching indexes. Schema: {}, tableName: {}, message: {}", new Object[]{schema, tableName, e.getMessage()});
            return Collections.emptyList();
        }
    }

    protected List<ColumnSchema> readColumns(String tableName, String catalog, String schema, DatabaseMetaData metaData) throws SQLException {
        List<ColumnData> columnsData = ResultSetMapper.map(metaData.getColumns(catalog, schema, tableName, null)).mapString("COLUMN_NAME", "name").mapInt("DATA_TYPE", "jdbcType").mapString("TYPE_NAME", "typeName").mapInt("COLUMN_SIZE", "size").mapYesNoBoolean("IS_NULLABLE", "nullable").mapInt("ORDINAL_POSITION", "position").mapYesNoBoolean("IS_AUTOINCREMENT", "autoIncrement").beans(ColumnData.class);
        List<ColumnData> uniqueColumns = ResultSetMapper.map(metaData.getIndexInfo(catalog, schema, tableName, true, false)).mapString("COLUMN_NAME", "name").beans(ColumnData.class);
        LinkedList<ColumnSchema> columns = new LinkedList<ColumnSchema>();
        for (ColumnData columnData : columnsData) {
            String typeName = columnData.getTypeName();
            int sqlType = columnData.getJdbcType();
            int length = columnData.getSize();
            NativeType nativeType = new NativeType(typeName, sqlType, length);
            DataType dataType = this.dataTypeRegistry.getType(nativeType);
            boolean unique = uniqueColumns.stream().filter(c -> c.getName() != null).anyMatch(c -> c.getName().equals(columnData.getName()));
            ColumnSchema column = new ColumnSchema(columnData.getName(), dataType, (Boolean)columnData.getNullable().or((Object)true), (Boolean)columnData.getAutoIncrement().or((Object)false), unique);
            columns.add(column);
        }
        return columns;
    }
}

