/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database;

import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.ConnectionTestResult;
import com.suncode.dbexplorer.database.DatabaseFactory;
import com.suncode.dbexplorer.database.internal.DatabaseConnectionTestResult;
import com.suncode.dbexplorer.util.authorization.AuthorizationHelper;
import com.suncode.dbexplorer.util.web.rest.RestController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class ConnectionController
extends RestController {
    private static final Logger log = LoggerFactory.getLogger(ConnectionController.class);
    private final DatabaseFactory databaseFactory;
    private final AuthorizationHelper authorizationHelper;

    @RequestMapping(value={"connection/test"}, method={RequestMethod.POST})
    public ResponseEntity<ConnectionTestResult> testConnection(@RequestBody ConnectionString connectionString) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        DatabaseConnectionTestResult result = this.databaseFactory.testConnection(connectionString);
        if (result.getSuccess().booleanValue()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)new ConnectionTestResult(result.getException().getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Autowired
    public ConnectionController(DatabaseFactory databaseFactory, AuthorizationHelper authorizationHelper) {
        this.databaseFactory = databaseFactory;
        this.authorizationHelper = authorizationHelper;
    }
}

