/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.util;

import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.pwfl.database.DataSourceFactory;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.Field;
import java.net.URI;
import javax.sql.DataSource;

public class SystemConnectionStringResolver {
    public static ConnectionString getSystemConnectionString() {
        DataSource systemDataSource = DataSourceFactory.getDataSource();
        if (systemDataSource instanceof HikariDataSource) {
            return SystemConnectionStringResolver.resolveHikariDataSource((HikariDataSource)systemDataSource);
        }
        return SystemConnectionStringResolver.resolveDataSourceReflect(systemDataSource);
    }

    private static ConnectionString resolveHikariDataSource(HikariDataSource dataSource) {
        String connectionUrl = dataSource.getJdbcUrl();
        return ConnectionString.builder().jdbcUrl(connectionUrl).user(dataSource.getUsername()).password(dataSource.getPassword()).type(DatabaseType.parseScheme(SystemConnectionStringResolver.parseJdbcUrl(connectionUrl).getScheme())).build();
    }

    private static ConnectionString resolveDataSourceReflect(DataSource dataSource) {
        String connectionUrl = SystemConnectionStringResolver.readPrivateProperty(dataSource, "url", String.class);
        return ConnectionString.builder().jdbcUrl(connectionUrl).user(SystemConnectionStringResolver.readPrivateProperty(dataSource, "username", String.class)).password(SystemConnectionStringResolver.readPrivateProperty(dataSource, "password", String.class)).type(DatabaseType.parseScheme(SystemConnectionStringResolver.parseJdbcUrl(connectionUrl).getScheme())).build();
    }

    private static <T> T readPrivateProperty(Object obj, String propertyName, Class<T> clazz) {
        Field field = obj.getClass().getDeclaredField(propertyName);
        field.setAccessible(true);
        return (T)field.get(obj);
    }

    public static URI parseJdbcUrl(String url) {
        if (url.contains("\\")) {
            url = SystemConnectionStringResolver.manageBackslash(url);
        }
        return URI.create(url.replaceFirst("jdbc:", ""));
    }

    private static String manageBackslash(String url) {
        int backslashIndex = url.indexOf("\\");
        int colonIndex = url.indexOf(":", backslashIndex);
        String instanceName = url.substring(backslashIndex + 1, colonIndex);
        return url.substring(0, backslashIndex) + url.substring(colonIndex) + ";instanceName=" + instanceName;
    }
}

