/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.permission.internal;

import com.google.common.collect.Lists;
import com.suncode.dbexplorer.alias.TablesSet;
import com.suncode.dbexplorer.alias.permission.AccessResource;
import com.suncode.dbexplorer.alias.permission.TablesSetPermission;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class TablesSetPermissionRepository
extends HibernateEditableDao<TablesSetPermission, Long> {
    public TablesSetPermission getResourcePermission(TablesSet set, AccessResource resource) {
        DetachedCriteria criteria = DetachedCriteria.forClass(TablesSetPermission.class).add((Criterion)Restrictions.eq((String)"tablesSet", (Object)set)).add((Criterion)Restrictions.eq((String)"resource", (Object)resource));
        return (TablesSetPermission)this.findOne(criteria);
    }

    public List<TablesSetPermission> getPermissionsForUser(User user) {
        Disjunction permissions = Restrictions.or((Criterion[])new Criterion[0]);
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.type).add((Criterion)permissions);
        Junction userPermissions = Restrictions.and((Criterion[])new Criterion[0]).add((Criterion)Restrictions.eq((String)"resource.type", (Object)((Object)AccessResource.ResourceType.USER))).add((Criterion)Restrictions.eq((String)"resource.id", (Object)user.getObjectId()));
        permissions.add((Criterion)userPermissions);
        if (!user.getGroups().isEmpty()) {
            Junction groupPermissions = Restrictions.and((Criterion[])new Criterion[0]).add((Criterion)Restrictions.eq((String)"resource.type", (Object)((Object)AccessResource.ResourceType.GROUP))).add(Restrictions.in((String)"resource.id", this.getGroupIds(user)));
            permissions.add((Criterion)groupPermissions);
        }
        return this.findByCriteria(criteria);
    }

    private List<Long> getGroupIds(User user) {
        ArrayList ids = Lists.newArrayList();
        for (UserGroup group : user.getGroups()) {
            ids.add(group.getObjectId());
        }
        return ids;
    }
}

