/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.data.util.importer;

import com.suncode.dbexplorer.alias.Table;
import com.suncode.dbexplorer.alias.data.util.importer.ImportHelper;
import com.suncode.dbexplorer.alias.data.util.importer.config.ImportStrategy;
import com.suncode.dbexplorer.alias.data.util.importer.config.ImportType;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.Record;
import com.suncode.pwfl.util.exception.ServiceException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExcelXSSFImporter
implements ImportStrategy {
    private static final Logger log = LoggerFactory.getLogger(ExcelXSSFImporter.class);
    public static final int XSSF_CELL_SIZE_BYTES = 630;
    private final ImportHelper importHelper;

    @Override
    public ImportType importMode() {
        return ImportType.STANDARD;
    }

    @Override
    public void validate(InputStream fileStream) throws IOException {
        ImportHelper.SheetData sheetData = this.importHelper.readSheetData(fileStream);
        long expectedMemoryToUse = (long)sheetData.getColumnNames().size() * sheetData.getRowCount() * 630L / 0x100000L;
        long freeMemory = Runtime.getRuntime().freeMemory() / 0x100000L;
        if (freeMemory < expectedMemoryToUse) {
            throw new ServiceException("dbex.grid.import.validation.size");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importRecords(InputStream inputStream, Database database, Table table, boolean clear) throws IOException {
        File tempPoiFile = this.importHelper.getTempPoiFile();
        tempPoiFile.deleteOnExit();
        try (FileOutputStream tempOutputStream = new FileOutputStream(tempPoiFile);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)tempOutputStream);
        }
        catch (Exception e) {
            tempPoiFile.delete();
            throw e;
        }
        try (OPCPackage opcPackage = this.importHelper.getOpcPackage(tempPoiFile);){
            XSSFWorkbook workbook = new XSSFWorkbook(opcPackage);
            XSSFFormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
            XSSFSheet sheet = workbook.getSheetAt(0);
            XSSFRow headerRow = sheet.getRow(0);
            String[] columnNames = new String[headerRow.getLastCellNum()];
            for (Cell cell : headerRow) {
                columnNames[cell.getColumnIndex()] = cell.getStringCellValue();
            }
            database.withinSession(session -> {
                if (clear) {
                    session.delete().from(table.getTableSchema().getFullName()).execute();
                }
                long rowsInBase = session.select().from(table.getTableSchema().getFullName()).count();
                for (Row row : sheet) {
                    if (row.getRowNum() == 0 || this.importHelper.isRowEmpty(row)) continue;
                    Record record = this.importHelper.createRecord(database, table, evaluator, columnNames, row, table.getTableSchema());
                    this.importHelper.processRecord(session, record, clear, row.getRowNum(), rowsInBase);
                }
                return null;
            });
        }
        finally {
            tempPoiFile.delete();
        }
    }

    @Autowired
    public ExcelXSSFImporter(ImportHelper importHelper) {
        this.importHelper = importHelper;
    }
}

