/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.data;

import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.AliasService;
import com.suncode.dbexplorer.alias.Column;
import com.suncode.dbexplorer.alias.Table;
import com.suncode.dbexplorer.alias.data.CreateTable;
import com.suncode.dbexplorer.alias.data.Filter;
import com.suncode.dbexplorer.alias.data.UpdateRecord;
import com.suncode.dbexplorer.alias.data.util.FileInputStreamSupplier;
import com.suncode.dbexplorer.alias.data.util.exporter.ExcelExporter;
import com.suncode.dbexplorer.alias.data.util.importer.config.ImportStrategy;
import com.suncode.dbexplorer.alias.data.util.importer.config.ImportType;
import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseFactory;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.Record;
import com.suncode.dbexplorer.database.RecordId;
import com.suncode.dbexplorer.database.SessionUnit;
import com.suncode.dbexplorer.database.query.Order;
import com.suncode.dbexplorer.database.query.Page;
import com.suncode.dbexplorer.database.query.Pagination;
import com.suncode.dbexplorer.database.schema.TableSchema;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import com.suncode.pwfl.util.exception.ServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataService {
    private final Map<ImportType, ImportStrategy> importByType;
    private final AliasService aliasService;
    private final DatabaseFactory databaseFactory;
    private final ExcelExporter excelExporter;

    public Page<Record> getPage(Long aliasId, final String schema, final String table, final Pagination pagination, final List<Filter> filters) {
        Alias alias = this.aliasService.getAlias(aliasId);
        ConnectionString connectionString = alias.getWrappedConnectionString();
        Database database = this.databaseFactory.create(connectionString);
        return database.withinSession(new SessionUnit<Page<Record>>(){

            @Override
            public Page<Record> doWork(DatabaseSession session) throws Exception {
                return session.select().from(schema, table).where(Filter.conditions(filters)).page(pagination);
            }
        });
    }

    public List<String> getUniqueColumnsForFileAndTable(Long aliasId, String schema, String tableName, List<String> fileColumnsNames) {
        Alias alias = this.aliasService.getAlias(aliasId);
        Table table = alias.getTable(schema, tableName, this.databaseFactory);
        List tableColumnNames = table.getColumns().stream().map(Column::getName).collect(Collectors.toList());
        List uniqueToTable = tableColumnNames.stream().filter(name -> !fileColumnsNames.contains(name)).collect(Collectors.toList());
        List uniqueToFile = fileColumnsNames.stream().filter(name -> !tableColumnNames.contains(name)).collect(Collectors.toList());
        ArrayList<String> uniqueNames = new ArrayList<String>();
        uniqueNames.addAll(uniqueToTable);
        uniqueNames.addAll(uniqueToFile);
        return uniqueNames;
    }

    private List<Record> getRecords(Long aliasId, final String schema, final String table, final List<Order> order, final List<Filter> filters) {
        Alias alias = this.aliasService.getAlias(aliasId);
        ConnectionString connectionString = alias.getWrappedConnectionString();
        Database database = this.databaseFactory.create(connectionString);
        return database.withinSession(new SessionUnit<List<Record>>(){

            @Override
            public List<Record> doWork(DatabaseSession session) throws Exception {
                return session.select().from(schema, table).where(Filter.conditions(filters)).addOrder(order.toArray(new Order[order.size()])).list();
            }
        });
    }

    public Record getRecord(Alias alias, final UpdateRecord record) {
        ConnectionString connectionString = alias.getWrappedConnectionString();
        Database database = this.databaseFactory.create(connectionString);
        return database.withinSession(new SessionUnit<Record>(){

            @Override
            public Record doWork(DatabaseSession session) throws Exception {
                return session.get(record.getSchema(), record.getTable(), RecordId.composite(record.getPrimaryKey()));
            }
        });
    }

    public void updateRecord(Long aliasId, final UpdateRecord record) {
        Alias alias = this.aliasService.getAlias(aliasId);
        ConnectionString connectionString = alias.getWrappedConnectionString();
        Database database = this.databaseFactory.create(connectionString);
        database.withinSession(new SessionUnit<Void>(){

            @Override
            public Void doWork(DatabaseSession session) throws Exception {
                session.update(record.record(session));
                return null;
            }
        });
    }

    public void addRecord(Long aliasId, final UpdateRecord record) {
        Alias alias = this.aliasService.getAlias(aliasId);
        ConnectionString connectionString = alias.getWrappedConnectionString();
        Database database = this.databaseFactory.create(connectionString);
        database.withinSession(new SessionUnit<Void>(){

            @Override
            public Void doWork(DatabaseSession session) throws Exception {
                session.insert(record.record(session));
                return null;
            }
        });
    }

    public void deleteRecords(Long aliasId, final List<UpdateRecord> records) {
        Alias alias = this.aliasService.getAlias(aliasId);
        ConnectionString connectionString = alias.getWrappedConnectionString();
        Database database = this.databaseFactory.create(connectionString);
        database.withinSession(new SessionUnit<Void>(){

            @Override
            public Void doWork(DatabaseSession session) throws Exception {
                for (UpdateRecord record : records) {
                    session.delete(record.record(session));
                }
                return null;
            }
        });
    }

    public void deleteRecord(Long aliasId, UpdateRecord record) {
        this.deleteRecords(aliasId, Arrays.asList(record));
    }

    public void createTable(Long aliasId, CreateTable table) {
        Alias alias = this.aliasService.getAlias(aliasId);
        ConnectionString connectionString = alias.getWrappedConnectionString();
        Database database = this.databaseFactory.create(connectionString);
        database.withinSession(session -> {
            session.createTable(table);
            return null;
        });
    }

    public void dropTable(Long aliasId, final TableSchema table) {
        Alias alias = this.aliasService.getAlias(aliasId);
        ConnectionString connectionString = alias.getWrappedConnectionString();
        Database database = this.databaseFactory.create(connectionString);
        database.withinSession(new SessionUnit<Void>(){

            @Override
            public Void doWork(DatabaseSession session) throws Exception {
                session.drop(table);
                return null;
            }
        });
    }

    public SXSSFWorkbook exportTable(Long aliasId, String schema, String tableName, Pagination pagination, List<Filter> filters) throws IOException {
        Alias alias = this.aliasService.getAlias(aliasId);
        Table table = alias.getTable(schema, tableName, this.databaseFactory);
        List<Record> records = this.getRecords(aliasId, schema, tableName, pagination.getOrder(), filters);
        return this.excelExporter.exportRecords(table, records);
    }

    public void importTable(Long aliasId, String schema, String tableName, boolean clear, FileInputStreamSupplier inputStreamSupplier, ImportType importType) throws IOException {
        Alias alias = this.aliasService.getAlias(aliasId);
        Table table = alias.getTable(schema, tableName, this.databaseFactory);
        ConnectionString connectionString = alias.getWrappedConnectionString();
        Database database = this.databaseFactory.create(connectionString);
        ImportStrategy importStrategy = this.importByType.get((Object)importType);
        if (importStrategy == null) {
            Translator translator = Translators.get(DataService.class);
            throw new ServiceException(translator.getMessage("dbex.grid.import.import.strategy.exception"));
        }
        try (InputStream inputStream = inputStreamSupplier.getInputStream();){
            importStrategy.validate(inputStream);
        }
        inputStream = inputStreamSupplier.getInputStream();
        try {
            importStrategy.importRecords(inputStream, database, table, clear);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Autowired
    public DataService(Map<ImportType, ImportStrategy> importByType, AliasService aliasService, DatabaseFactory databaseFactory, ExcelExporter excelExporter) {
        this.importByType = importByType;
        this.aliasService = aliasService;
        this.databaseFactory = databaseFactory;
        this.excelExporter = excelExporter;
    }
}

