/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.upgrade;

import com.plusmpm.security.TextCipher;
import com.suncode.pwfl.database.DataSourceFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptPasswordsChange
implements CustomTaskChange {
    private static final Logger log = LoggerFactory.getLogger(EncryptPasswordsChange.class);

    public void execute(Database database) throws CustomChangeException {
        try (Connection connection = DataSourceFactory.getDataSource().getConnection();){
            try {
                connection.setAutoCommit(false);
                Map<Integer, String> passwords = this.getPasswordsFromDbexAlias(connection);
                log.debug("Encrypting passwords");
                passwords.forEach((id, password) -> this.encodePassword(connection, (int)id, (String)password));
                connection.commit();
            }
            catch (Exception e) {
                connection.rollback();
                throw new RuntimeException(e);
            }
        }
        catch (Throwable t) {
            throw new CustomChangeException(t);
        }
    }

    private Map<Integer, String> getPasswordsFromDbexAlias(Connection connection) throws SQLException {
        HashMap<Integer, String> passwords = new HashMap<Integer, String>();
        String query = "SELECT id, db_password FROM dbex_alias";
        PreparedStatement statement = connection.prepareStatement(query);
        ResultSet resultSet = statement.executeQuery();
        while (resultSet.next()) {
            String password = resultSet.getString("db_password");
            if (!StringUtils.isNotBlank((CharSequence)password)) continue;
            passwords.put(resultSet.getInt("id"), password);
        }
        return passwords;
    }

    private void encodePassword(Connection connection, int id, String password) {
        String updateQuery = "UPDATE DBEX_ALIAS SET DB_PASSWORD = ? WHERE ID = ? ";
        PreparedStatement updateStatement = connection.prepareStatement(updateQuery);
        updateStatement.setString(1, TextCipher.encrypt((String)password));
        updateStatement.setInt(2, id);
        updateStatement.executeUpdate();
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

