/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.schema;

import com.google.common.collect.Iterables;
import java.util.Set;
import org.springframework.util.Assert;

public class PrimaryKey {
    private String name;
    private Set<String> columns;
    private boolean createdFromIndexes;

    public PrimaryKey(String name, Set<String> columns) {
        this.name = name;
        this.columns = columns;
    }

    public PrimaryKey(String name, Set<String> columns, boolean createdFromIndexes) {
        this.name = name;
        this.columns = columns;
        this.createdFromIndexes = createdFromIndexes;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCreatedFromIndexes() {
        return this.createdFromIndexes;
    }

    public boolean isComposite() {
        return this.columns.size() > 1;
    }

    public String[] getColumns() {
        return (String[])Iterables.toArray(this.columns, String.class);
    }

    public String getColumn() {
        Assert.state((!this.isComposite() ? 1 : 0) != 0, (String)"This primary key contains more than 1 column");
        return (String)Iterables.getOnlyElement(this.columns);
    }
}

