/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.type;

import com.suncode.dbexplorer.database.internal.type.DataTypeHandler;
import com.suncode.dbexplorer.database.type.DataType;
import org.hibernate.SQLQuery;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HibernateDataTypeHandler
implements DataTypeHandler {
    private static Logger logger = LoggerFactory.getLogger(HibernateDataTypeHandler.class);

    protected abstract Type resolveHibernateType(DataType var1);

    @Override
    public void bindParameter(DataType dataType, String parameterName, Object rawValue, SQLQuery query) {
        Object value = rawValue;
        Type hibernateType = this.resolveHibernateType(dataType);
        if (value != null && this.needConversion(value, hibernateType)) {
            try {
                value = this.convert(rawValue, hibernateType.getReturnedClass(), dataType);
            }
            catch (RuntimeException e) {
                logger.error("Could not convert value [{}] to {}", rawValue, (Object)hibernateType.getReturnedClass());
                throw e;
            }
        }
        query.setParameter(parameterName, value, hibernateType);
    }

    @Override
    public void setScalar(DataType dataType, String columnAlias, SQLQuery query) {
        query.addScalar(columnAlias, this.resolveHibernateType(dataType));
    }

    protected abstract Object convert(Object var1, Class<?> var2, DataType var3);

    private boolean needConversion(Object value, Type type) {
        return !type.getReturnedClass().isInstance(value);
    }
}

