/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.support;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.util.Assert;

public class ResultSetMapper {
    private final ResultSet resultSet;
    private final Map<String, Extractor> mappings = new HashMap<String, Extractor>();

    private ResultSetMapper(ResultSet resultSet) {
        Assert.notNull((Object)resultSet, (String)"Result set cannot be null");
        this.resultSet = resultSet;
    }

    public static ResultSetMapper map(ResultSet resultSet) {
        return new ResultSetMapper(resultSet);
    }

    public ResultSetMapper mapString(String column) {
        return this.mapString(column, null);
    }

    public ResultSetMapper mapString(String column, String alias) {
        this.mappings.put(column, new StringExtractor(alias));
        return this;
    }

    public ResultSetMapper mapInt(String column) {
        return this.mapInt(column, null);
    }

    public ResultSetMapper mapInt(String column, String alias) {
        this.mappings.put(column, new IntExtractor(alias));
        return this;
    }

    public ResultSetMapper mapYesNoBoolean(String column, String alias) {
        this.mappings.put(column, new YesNoExtractor(alias));
        return this;
    }

    public <T> List<T> beans(Class<T> type) throws SQLException {
        try (ResultSet resultSet = this.resultSet;){
            Assert.state((!this.resultSet.isClosed() ? 1 : 0) != 0, (String)"Result set cannot be closed");
            Assert.state((!this.mappings.isEmpty() ? 1 : 0) != 0, (String)"Mappings shouldn't be empty");
            ArrayList<Object> results = new ArrayList<Object>();
            while (this.resultSet.next()) {
                MutablePropertyValues properties = new MutablePropertyValues();
                for (Map.Entry<String, Extractor> entry : this.mappings.entrySet()) {
                    properties.add(entry.getValue().alias, entry.getValue().extract(this.resultSet, entry.getKey()));
                }
                Object row = BeanUtils.instantiate(type);
                BeanWrapperImpl beanWrapper = new BeanWrapperImpl(row);
                beanWrapper.setPropertyValues((PropertyValues)properties);
                results.add(row);
            }
            ArrayList<Object> arrayList = results;
            return arrayList;
        }
    }

    public <T> List<T> single() throws SQLException {
        try (ResultSet resultSet = this.resultSet;){
            Assert.state((!this.resultSet.isClosed() ? 1 : 0) != 0, (String)"Result set cannot be closed");
            Assert.state((this.mappings.size() == 1 ? 1 : 0) != 0, (String)"Mappings shouldn't be of size 1");
            String column = (String)Iterables.getFirst(this.mappings.keySet(), null);
            Extractor extractor = this.mappings.get(column);
            ArrayList<Object> results = new ArrayList<Object>();
            while (this.resultSet.next()) {
                results.add(extractor.extract(this.resultSet, column));
            }
            ArrayList<Object> arrayList = results;
            return arrayList;
        }
    }

    private static class StringExtractor
    extends Extractor {
        StringExtractor(String alias) {
            super(alias);
        }

        @Override
        String extract(ResultSet rs, String column) throws SQLException {
            return rs.getString(column);
        }
    }

    private static class IntExtractor
    extends Extractor {
        IntExtractor(String alias) {
            super(alias);
        }

        @Override
        Integer extract(ResultSet rs, String column) throws SQLException {
            return rs.getInt(column);
        }
    }

    private static class YesNoExtractor
    extends Extractor {
        YesNoExtractor(String alias) {
            super(alias);
        }

        Optional<Boolean> extract(ResultSet rs, String column) throws SQLException {
            String value = rs.getString(column);
            if ("YES".equals(value)) {
                return Optional.of((Object)Boolean.TRUE);
            }
            if ("NO".equals(value)) {
                return Optional.of((Object)Boolean.FALSE);
            }
            return Optional.absent();
        }
    }

    private static abstract class Extractor {
        String alias;

        Extractor(String alias) {
            this.alias = alias;
        }

        abstract Object extract(ResultSet var1, String var2) throws SQLException;
    }
}

