/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.sqlserver;

import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.internal.sqlserver.SqlServerConnectionUrlResolver;
import com.suncode.dbexplorer.database.internal.sqlserver.SqlServerDataTypeRegistry;
import com.suncode.dbexplorer.database.internal.sqlserver.SqlServerSchemaLoader;
import com.suncode.dbexplorer.database.internal.support.AbstractDatabaseImplementor;
import java.util.List;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SqlServerDatabase
extends AbstractDatabaseImplementor {
    @Autowired
    public SqlServerDatabase(SqlServerSchemaLoader schemaLoader, SqlServerConnectionUrlResolver urlResolver, SqlServerDataTypeRegistry typeRegistry) {
        super(DatabaseType.SQLSERVER, schemaLoader, urlResolver, typeRegistry);
    }

    @Override
    protected String getDriverClassName() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    public String getCurrentSchemaName(DatabaseSession session) {
        return (String)session.hibernateSession().createSQLQuery("select SCHEMA_NAME() as " + this.escapeColumnName("schema")).addScalar("schema", (Type)StandardBasicTypes.STRING).uniqueResult();
    }

    @Override
    public List<String> getSchemasNames(DatabaseSession session) {
        return session.hibernateSession().createSQLQuery("SELECT schema_name as 'schema' FROM INFORMATION_SCHEMA.SCHEMATA WHERE schema_name NOT IN ('guest', 'INFORMATION_SCHEMA', 'sys') AND schema_name NOT LIKE 'db[_]%'").addScalar("schema", (Type)StandardBasicTypes.STRING).list();
    }
}

