/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.query.support;

import com.suncode.dbexplorer.database.internal.query.CreateQueryImpl;
import com.suncode.dbexplorer.database.internal.query.support.BuildSqlQuery;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BuildCreateQueryPostgres
extends BuildSqlQuery {
    public BuildCreateQueryPostgres(String tableName, List<CreateQueryImpl.Column> columns, Set<Integer> primaryKeyIndexes, Map<String, String[]> foreignKeys) {
        super(tableName, columns, primaryKeyIndexes, foreignKeys);
    }

    @Override
    public String buildSql() {
        StringBuilder sql = new StringBuilder();
        for (CreateQueryImpl.Column column : this.columns) {
            sql.append(column.getName() + " ");
            sql.append((column.isAutoincrement() ? "SERIAL" : column.getType()) + " ");
            sql.append(column.isNullable() ? " " : "NOT NULL ");
            sql.append(this.foreignKeys.containsKey(column.getName()) ? this.getSqlForForeignKeys(column) : ", ");
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append(this.getSqlForPrimaryKeys());
        sql.append(");");
        return sql.toString();
    }

    @Override
    protected String getSqlForPrimaryKeys() {
        StringBuilder sql = new StringBuilder();
        if (!this.primaryKeyIndexes.isEmpty()) {
            sql.append(", PRIMARY KEY (");
            for (Integer primaryId : this.primaryKeyIndexes) {
                sql.append(((CreateQueryImpl.Column)this.columns.get(primaryId)).getName() + ", ");
            }
            sql.delete(sql.length() - 2, sql.length());
            sql.append(")");
        }
        return sql.toString();
    }

    protected String getSqlForForeignKeys(CreateQueryImpl.Column column) {
        String[] foreignData = (String[])this.foreignKeys.get(column.getName());
        String sql = "REFERENCES " + foreignData[1] + " (" + foreignData[2] + "), ";
        return sql;
    }
}

