/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.query;

import com.google.common.collect.Lists;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.internal.DatabaseImplementor;
import com.suncode.dbexplorer.database.internal.query.AbstractQuery;
import com.suncode.dbexplorer.database.internal.query.QueryContextImpl;
import com.suncode.dbexplorer.database.internal.type.DataTypeHandler;
import com.suncode.dbexplorer.database.query.InsertQuery;
import com.suncode.dbexplorer.database.query.QueryContext;
import com.suncode.dbexplorer.database.query.QueryParameter;
import com.suncode.dbexplorer.database.schema.ColumnSchema;
import com.suncode.dbexplorer.database.type.BasicDataType;
import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import com.suncode.pwfl.util.exception.ServiceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ibatis.jdbc.SQL;
import org.hibernate.SQLQuery;
import org.hibernate.query.NativeQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class InsertQueryImpl
extends AbstractQuery
implements InsertQuery {
    private static final Logger log = LoggerFactory.getLogger(InsertQueryImpl.class);
    private final List<String> insertColumns = Lists.newArrayList();
    private final List<Object> insertValues = Lists.newArrayList();

    public InsertQueryImpl(DatabaseSession session, DatabaseImplementor implementor) {
        super(session, implementor);
    }

    @Override
    public InsertQuery into(String table) {
        Assert.hasText((String)table, (String)"Table must have text");
        AbstractQuery.TablePathInfo pathInfo = this.getPathInfo(table);
        return this.into(pathInfo.getSchema(), pathInfo.getName());
    }

    @Override
    public InsertQuery into(String schema, String table) {
        Assert.hasText((String)schema, (String)"Schema must have text");
        Assert.hasText((String)table, (String)"Table must have text");
        this.rootTable = this.session.getDatabase().getSchema(schema).getTable(table);
        return this;
    }

    @Override
    public InsertQuery value(String column, Object value) {
        Assert.hasText((String)column, (String)"Column must have text");
        this.insertValues.add(value);
        this.insertColumns.add(column);
        return this;
    }

    @Override
    public InsertQuery values(Collection<String> columns, Collection<Object> values) {
        Assert.isTrue((columns.size() == values.size() ? 1 : 0) != 0, (String)"Column size must be equal to values size");
        this.insertValues.addAll(values);
        this.insertColumns.addAll(columns);
        return this;
    }

    @Override
    public int execute() {
        QueryContextImpl queryContext = new QueryContextImpl(this.rootTable, this.implementor);
        SQL rawSql = this.buildSql(queryContext);
        StringBuilder sql = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(rawSql.toString().replace("\n", " "), " \"=><(),", true);
        ArrayList parameters = Lists.newArrayList();
        for (int i = 0; i < this.insertColumns.size(); ++i) {
            String column = this.insertColumns.get(i);
            ColumnSchema columnSchema = this.rootTable.getColumn(column);
            if (columnSchema.isAutoIncrement() || BasicDataType.BINARY.is(columnSchema.getType()) || BasicDataType.UNKNOWN.is(columnSchema.getType())) continue;
            Object value = this.insertValues.get(i);
            if (BasicDataType.STRING.is(columnSchema.getType()) && value instanceof String) {
                String s = (String)value;
                int maxLength = columnSchema.getType().getNativeType().getLength();
                int valueLength = s.length();
                if (maxLength > 0 && valueLength > maxLength) {
                    Translator translator = Translators.get(InsertQueryImpl.class);
                    String message = translator.getMessage("dbex.data.column.exceeded.exception", new Object[]{columnSchema.getName(), s});
                    log.info(message);
                    throw new ServiceException(message);
                }
            }
            QueryParameter parameter = new QueryParameter(value, queryContext.getTypeOf(column));
            parameter.setAssociatedColumn(column);
            parameters.add(parameter);
        }
        int paramCount = 0;
        ArrayList binded = Lists.newArrayList();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("?")) {
                QueryParameter param = (QueryParameter)parameters.get(paramCount);
                String paramName = "param" + paramCount;
                ++paramCount;
                binded.add(new BindParam(paramName, param));
                sql.append(":").append(paramName);
                continue;
            }
            sql.append(token);
        }
        NativeQuery sqlQuery = this.session.hibernateSession().createSQLQuery(sql.toString());
        for (BindParam param : binded) {
            DataType type = param.parameter.getType();
            DataTypeHandler typeHandler = this.implementor.getTypeRegistry().getTypeHandler(type);
            try {
                typeHandler.bindParameter(type, param.name, param.parameter.getValue(), (SQLQuery)sqlQuery);
            }
            catch (RuntimeException ex) {
                log.error("Error while binding value of column {}", (Object)param.parameter.getAssociatedColumn());
                throw ex;
            }
        }
        return sqlQuery.executeUpdate();
    }

    private SQL buildSql(QueryContext queryContext) {
        SQL sql = (SQL)new SQL().INSERT_INTO(this.implementor.escapeTableName(this.rootTable.getFullName()));
        for (String columnName : this.insertColumns) {
            ColumnSchema column = this.rootTable.getColumn(columnName);
            if (column.isAutoIncrement() || BasicDataType.BINARY.is(column.getType()) || BasicDataType.UNKNOWN.is(column.getType())) continue;
            sql.VALUES(this.implementor.escapeColumnName(columnName), "?");
        }
        return sql;
    }

    private static class BindParam {
        private final String name;
        private final QueryParameter parameter;

        public BindParam(String name, QueryParameter parameter) {
            this.name = name;
            this.parameter = parameter;
        }
    }
}

