/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.query;

import com.google.common.collect.Lists;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.internal.DatabaseImplementor;
import com.suncode.dbexplorer.database.internal.query.AbstractQuery;
import com.suncode.dbexplorer.database.internal.query.QueryContextImpl;
import com.suncode.dbexplorer.database.internal.type.DataTypeHandler;
import com.suncode.dbexplorer.database.query.Condition;
import com.suncode.dbexplorer.database.query.DeleteQuery;
import com.suncode.dbexplorer.database.query.QueryContext;
import com.suncode.dbexplorer.database.query.QueryParameter;
import com.suncode.dbexplorer.database.type.DataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ibatis.jdbc.SQL;
import org.hibernate.SQLQuery;
import org.hibernate.query.NativeQuery;
import org.springframework.util.Assert;

public class DeleteQueryImpl
extends AbstractQuery
implements DeleteQuery {
    private List<Condition> whereConditions = new ArrayList<Condition>();

    public DeleteQueryImpl(DatabaseSession session, DatabaseImplementor implementor) {
        super(session, implementor);
    }

    @Override
    public DeleteQuery from(String table) {
        Assert.hasText((String)table, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        AbstractQuery.TablePathInfo pathInfo = this.getPathInfo(table);
        return this.from(pathInfo.getSchema(), pathInfo.getName());
    }

    @Override
    public DeleteQuery from(String schema, String table) {
        Assert.hasText((String)schema, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        Assert.hasText((String)table, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        this.rootTable = this.session.getDatabase().getSchema(schema).getTable(table);
        return this;
    }

    @Override
    public DeleteQuery where(Condition condition) {
        Assert.notNull((Object)condition, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.whereConditions.add(condition);
        return this;
    }

    @Override
    public int execute() {
        QueryContextImpl queryContext = new QueryContextImpl(this.rootTable, this.implementor);
        SQL rawSql = this.buildSql(queryContext);
        StringBuilder sql = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(rawSql.toString().replace("\n", " "), " \"=><(),", true);
        ArrayList parameters = Lists.newArrayList();
        for (Condition condition : this.whereConditions) {
            Collections.addAll(parameters, condition.getParameters(queryContext));
        }
        int paramCount = 0;
        ArrayList binded = Lists.newArrayList();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("?")) {
                QueryParameter param = (QueryParameter)parameters.get(paramCount);
                String paramName = "param" + paramCount;
                ++paramCount;
                binded.add(new BindParam(paramName, param));
                sql.append(":" + paramName);
                continue;
            }
            sql.append(token);
        }
        NativeQuery sqlQuery = this.session.hibernateSession().createSQLQuery(sql.toString());
        for (BindParam param : binded) {
            DataType type = param.parameter.getType();
            DataTypeHandler typeHandler = this.implementor.getTypeRegistry().getTypeHandler(type);
            typeHandler.bindParameter(type, param.name, param.parameter.getValue(), (SQLQuery)sqlQuery);
        }
        return sqlQuery.executeUpdate();
    }

    private SQL buildSql(QueryContext queryContext) {
        SQL sql = (SQL)new SQL().DELETE_FROM(this.implementor.escapeTableName(this.rootTable.getFullName()));
        for (Condition condition : this.whereConditions) {
            String conditionSql = condition.toSql(queryContext);
            sql.WHERE(conditionSql);
        }
        return sql;
    }

    private static class BindParam {
        String name;
        QueryParameter parameter;

        public BindParam(String name, QueryParameter parameter) {
            this.name = name;
            this.parameter = parameter;
        }
    }
}

