/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.postgres;

import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.internal.postgres.PostgresConnectionUrlResolver;
import com.suncode.dbexplorer.database.internal.postgres.PostgresDataTypeRegistry;
import com.suncode.dbexplorer.database.internal.postgres.PostgresSchemaLoader;
import com.suncode.dbexplorer.database.internal.support.AbstractDatabaseImplementor;
import java.util.List;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PostgresDatabase
extends AbstractDatabaseImplementor {
    @Autowired
    public PostgresDatabase(PostgresSchemaLoader schemaLoader, PostgresConnectionUrlResolver urlResolver, PostgresDataTypeRegistry typeRegistry) {
        super(DatabaseType.POSTGRES, schemaLoader, urlResolver, typeRegistry);
    }

    @Override
    protected String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    @Override
    public String getCurrentSchemaName(DatabaseSession session) {
        return (String)session.hibernateSession().createSQLQuery("select current_schema() as schema").addScalar("schema", (Type)StandardBasicTypes.STRING).uniqueResult();
    }

    @Override
    public List<String> getSchemasNames(DatabaseSession session) {
        return session.hibernateSession().createSQLQuery("select schema_name as schema from information_schema.schemata where schema_name NOT LIKE 'pg_%' AND schema_name != 'information_schema'").addScalar("schema", (Type)StandardBasicTypes.STRING).list();
    }
}

