/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.db2as400;

import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.internal.db2as400.DB2AS400ConnectionUrlResolver;
import com.suncode.dbexplorer.database.internal.db2as400.DB2AS400DataTypeRegistry;
import com.suncode.dbexplorer.database.internal.db2as400.DB2AS400SchemaLoader;
import com.suncode.dbexplorer.database.internal.support.AbstractDatabaseImplementor;
import java.util.List;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DB2AS400Database
extends AbstractDatabaseImplementor {
    private static final Logger log = LoggerFactory.getLogger(DB2AS400Database.class);

    @Autowired
    public DB2AS400Database(DB2AS400SchemaLoader schemaLoader, DB2AS400ConnectionUrlResolver urlResolver, DB2AS400DataTypeRegistry typeRegistry) {
        super(DatabaseType.DB2AS400, schemaLoader, urlResolver, typeRegistry);
    }

    @Override
    protected String getDriverClassName() {
        return "com.ibm.as400.access.AS400JDBCDriver";
    }

    @Override
    public String getCurrentSchemaName(DatabaseSession session) {
        return (String)session.hibernateSession().createSQLQuery("select current_schema as schema from sysibm.sysdummy1").addScalar("schema", (Type)StandardBasicTypes.STRING).uniqueResult();
    }

    @Override
    public List<String> getSchemasNames(DatabaseSession session) {
        return session.hibernateSession().createSQLQuery("select schema_name AS schema from QSYS2.schemata WHERE SCHEMA_OWNER <> 'QSYS' AND SCHEMA_OWNER <> 'ITERAOWNER' AND SCHEMA_OWNER <> 'QDFTOWN'  AND SCHEMA_OWNER <> 'QPGMR' AND SCHEMA_OWNER <> 'QSECOFR' AND SCHEMA_OWNER <> 'QBRMS' AND SCHEMA_OWNER <> 'QDESADM' AND SCHEMA_OWNER <> 'QDOC' AND SCHEMA_OWNER <> 'QEJBSVR' AND SCHEMA_OWNER <> 'QLPINSTALL' AND SCHEMA_OWNER <> 'QSRV' AND SCHEMA_OWNER <> 'TSPUSER' ").addScalar("schema", (Type)StandardBasicTypes.STRING).list();
    }
}

