/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.SessionUnit;
import com.suncode.dbexplorer.database.exception.DatabaseNotAvailableException;
import com.suncode.dbexplorer.database.internal.DatabaseImplementor;
import com.suncode.dbexplorer.database.internal.DatabaseSessionImpl;
import com.suncode.dbexplorer.database.internal.type.DataTypeRegistry;
import com.suncode.dbexplorer.database.schema.DatabaseSchema;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.model.TypeContributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.LocalSessionFactoryBuilder;
import org.springframework.util.Assert;

public class DatabaseImpl
implements Database,
DatabaseImplementor {
    private static final Logger log = LoggerFactory.getLogger(DatabaseImpl.class);
    private static final int MAX_SUPPORTED_ORACLE_VERSION = 11;
    private static final String MAX_SUPPORTED_ORACLE_DIALECT = "org.hibernate.dialect.Oracle10gDialect";
    private final DatabaseImplementor implementor;
    private final DataSource dataSource;
    private Boolean initialized = false;
    private Boolean initializing = false;
    private String catalog;
    private String defaultSchemaName;
    private List<String> schemasNames;
    private SessionFactory sessionFactory;
    private java.util.function.Supplier<List<DatabaseSchema>> schemas;

    public DatabaseImpl(DataSource dataSource, DatabaseImplementor implementor, String schema, Boolean available) {
        Assert.notNull((Object)dataSource, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull((Object)implementor, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.implementor = implementor;
        this.dataSource = dataSource;
        this.startDatabaseConnection(available);
    }

    private void startDatabaseConnection(Boolean available) {
        if (available.booleanValue()) {
            try {
                this.initDatabaseConnection();
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                this.clearDatabaseConnection();
            }
        } else {
            this.clearDatabaseConnection();
        }
    }

    private void initDatabaseConnection() throws Exception {
        if (!this.initializing.booleanValue()) {
            this.initializing = true;
            try {
                LocalSessionFactoryBuilder builder = new LocalSessionFactoryBuilder(this.dataSource);
                if (this.implementor instanceof TypeContributor) {
                    builder.registerTypeContributor((TypeContributor)this.implementor);
                }
                if (this.isOracleDatabase() && !this.isSupportedOracleVersion()) {
                    builder.setProperty("hibernate.dialect", MAX_SUPPORTED_ORACLE_DIALECT);
                }
                this.setSessionFactoryProperties(builder);
                this.sessionFactory = builder.buildSessionFactory();
                DatabaseSession session = this.openSession();
                this.catalog = this.implementor.getCatalog(session);
                this.defaultSchemaName = this.implementor.getCurrentSchemaName(session);
                this.schemasNames = this.implementor.getSchemasNames(session);
                session.commit();
                this.schemas = () -> ((Supplier)Suppliers.memoize(() -> this.readSchemas(this.schemasNames))).get();
                this.initialized = true;
            }
            finally {
                this.initializing = false;
            }
        }
    }

    private List<DatabaseSchema> readSchemas(List<String> schemasNames) {
        return this.withinSession(session -> this.implementor.readSchemas(session, schemasNames));
    }

    private void clearDatabaseConnection() {
        this.close();
        this.catalog = null;
        this.defaultSchemaName = null;
        this.schemasNames = null;
        this.sessionFactory = null;
        this.schemas = null;
        this.initialized = false;
    }

    @Override
    public String getSchemaName() {
        return this.getDefaultSchemaName();
    }

    @Override
    public String getDefaultSchemaName() {
        return this.reinitIfNeededAndReturn(() -> this.defaultSchemaName);
    }

    @Override
    public List<String> getSchemasNames() {
        return this.reinitIfNeededAndReturn(() -> this.schemasNames);
    }

    @Override
    public List<DatabaseSchema> getSchemas() {
        return this.reinitIfNeededAndReturn(() -> this.schemas.get());
    }

    public SessionFactory getSessionFactory() {
        return this.reinitIfNeededAndReturn(() -> this.sessionFactory);
    }

    @Override
    public String getCatalog() {
        return this.reinitIfNeededAndReturn(() -> this.catalog);
    }

    private <T> T reinitIfNeededAndReturn(java.util.function.Supplier<T> supplier) {
        if (this.initialized.booleanValue()) {
            return supplier.get();
        }
        try {
            this.initDatabaseConnection();
            return supplier.get();
        }
        catch (Exception ex) {
            this.clearDatabaseConnection();
            throw new DatabaseNotAvailableException(ex);
        }
    }

    @Override
    public DatabaseSchema getSchema() {
        return this.getSchema(this.defaultSchemaName);
    }

    @Override
    public DatabaseSchema getSchema(String name) {
        for (DatabaseSchema schema : this.getSchemas()) {
            if (!schema.getName().equals(name)) continue;
            return schema;
        }
        throw new IllegalArgumentException("There is no database schema with name: " + name);
    }

    @Override
    public void updateSchema() {
        this.schemaUpdated();
    }

    @Override
    public void schemaUpdated() {
        DatabaseSession session = this.openSession();
        this.schemasNames = this.implementor.getSchemasNames(session);
        this.schemas = () -> ((Supplier)Suppliers.memoize(() -> this.readSchemas(this.schemasNames))).get();
        session.commit();
    }

    @Override
    public DatabaseSession openSession() {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            DatabaseSessionImpl session = new DatabaseSessionImpl(connection, this);
            this.initialized = true;
            return session;
        }
        catch (SQLException ex) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.clearDatabaseConnection();
            throw new DatabaseNotAvailableException(ex);
        }
    }

    @Override
    public <T> T withinSession(SessionUnit<T> unit) {
        T value;
        Assert.notNull(unit, (String)"[Assertion failed] - this argument is required; it must not be null");
        DatabaseSession session = this.openSession();
        try {
            value = unit.doWork(session);
        }
        catch (Error | RuntimeException ex) {
            session.rollback();
            throw ex;
        }
        catch (Exception ex) {
            session.rollback();
            throw new RuntimeException(ex);
        }
        session.commit();
        return value;
    }

    public void close() {
        try {
            if (this.sessionFactory != null) {
                this.sessionFactory.close();
            }
        }
        catch (HibernateException hibernateException) {
            // empty catch block
        }
    }

    @Override
    public boolean handles(DatabaseType type) {
        return this.implementor.handles(type);
    }

    @Override
    public Class<? extends Driver> getDriverClass() {
        return this.implementor.getDriverClass();
    }

    @Override
    public DataTypeRegistry getTypeRegistry() {
        return this.implementor.getTypeRegistry();
    }

    @Override
    public String buildConnectionUrl(ConnectionString connectionString) {
        return this.implementor.buildConnectionUrl(connectionString);
    }

    @Override
    public String getCatalog(DatabaseSession session) {
        return this.implementor.getCatalog(session);
    }

    @Override
    public String getCurrentSchemaName(DatabaseSession session) {
        return this.implementor.getCurrentSchemaName(session);
    }

    @Override
    public List<String> getSchemasNames(DatabaseSession session) {
        return this.implementor.getSchemasNames(session);
    }

    @Override
    public List<DatabaseSchema> readSchemas(DatabaseSession session, List<String> schemasNames) {
        return this.implementor.readSchemas(session, schemasNames);
    }

    @Override
    public String escapeColumnName(String columnName) {
        return this.implementor.escapeColumnName(columnName);
    }

    @Override
    public String escapeTableName(String tableName) {
        return this.implementor.escapeTableName(tableName);
    }

    private boolean isOracleDatabase() throws SQLException {
        DatabaseMetaData metaData = this.dataSource.getConnection().getMetaData();
        return metaData.getDatabaseProductName().toLowerCase().contains("oracle");
    }

    private boolean isSupportedOracleVersion() throws SQLException {
        DatabaseMetaData metaData = this.dataSource.getConnection().getMetaData();
        return metaData.getDatabaseMajorVersion() <= 11;
    }

    private void setSessionFactoryProperties(LocalSessionFactoryBuilder builder) {
        builder.setProperty("hibernate.native_exception_handling_51_compliance", "true");
    }

    public DatabaseImplementor getImplementor() {
        return this.implementor;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

