/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal;

import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.internal.DatabaseConnectionTestResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.stereotype.Service;

@Service
public class DatabaseAvailabilityResolver {
    private static final Logger log = LoggerFactory.getLogger(DatabaseAvailabilityResolver.class);
    private static final Long MIN_TIMEOUT_SEC = 5L;
    private static final Long TIMEOUT_EXTRA_TIME_SEC = 15L;
    private final Map<Integer, Long> timeoutCache = new HashMap<Integer, Long>();

    public DatabaseConnectionTestResult testConnection(ConnectionString connectionString, DataSource dataSource) {
        Long timeout = this.getTimeout(connectionString);
        String url = this.getUrl(dataSource);
        try {
            log.debug("Testing connection for connection string [{}] with timeout {} sec", (Object)url, (Object)timeout);
            return this.runAsync(connectionString, dataSource, timeout);
        }
        catch (TimeoutException ex) {
            log.error("Connection timeout {} sec for connection string [{}]", (Object)timeout, (Object)url);
            return DatabaseConnectionTestResult.failure(ex);
        }
        catch (Exception ex) {
            log.error("Cannot connect for connection string: [{}]", (Object)url);
            log.error(ex.getMessage(), (Throwable)ex);
            return DatabaseConnectionTestResult.failure(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseConnectionTestResult runAsync(ConnectionString connectionString, DataSource dataSource, Long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<DatabaseConnectionTestResult> future = executor.submit(() -> this.runTest(connectionString, dataSource));
            DatabaseConnectionTestResult databaseConnectionTestResult = future.get(timeout, TimeUnit.SECONDS);
            return databaseConnectionTestResult;
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getTimeout(ConnectionString connectionString) {
        Map<Integer, Long> map = this.timeoutCache;
        synchronized (map) {
            return this.timeoutCache.getOrDefault(connectionString.hashCode(), MIN_TIMEOUT_SEC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimeout(ConnectionString connectionString, DataSource dataSource, Long connectionTimeMs) {
        Map<Integer, Long> map = this.timeoutCache;
        synchronized (map) {
            String url = this.getUrl(dataSource);
            Long connectionTimeSec = connectionTimeMs / 1000L;
            if (connectionTimeSec > MIN_TIMEOUT_SEC) {
                Long newTimeoutSec = connectionTimeSec + TIMEOUT_EXTRA_TIME_SEC;
                log.debug("Updating timeout for connection string [{}] to {} sec", (Object)url, (Object)newTimeoutSec);
                this.timeoutCache.put(connectionString.hashCode(), newTimeoutSec);
            } else {
                log.debug("Resetting timeout for connection string [{}]", (Object)url);
                this.timeoutCache.remove(connectionString.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTimeout(ConnectionString connectionString, DataSource dataSource) {
        Map<Integer, Long> map = this.timeoutCache;
        synchronized (map) {
            log.debug("Resetting timeout for connection string [{}]", (Object)this.getUrl(dataSource));
            this.timeoutCache.remove(connectionString.hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseConnectionTestResult runTest(ConnectionString connectionString, DataSource dataSource) {
        String url = this.getUrl(dataSource);
        Connection connection = null;
        try {
            long startedTime = System.currentTimeMillis();
            connection = dataSource.getConnection();
            long finishedTime = System.currentTimeMillis();
            long finalTime = finishedTime - startedTime;
            log.debug("Connected with {} after {} ms", (Object)url, (Object)finalTime);
            this.updateTimeout(connectionString, dataSource, finalTime);
            DatabaseConnectionTestResult databaseConnectionTestResult = DatabaseConnectionTestResult.success();
            return databaseConnectionTestResult;
        }
        catch (SQLException ex) {
            log.error("Cannot connect with connection string [{}]", (Object)url);
            log.error(ex.getMessage(), (Throwable)ex);
            this.deleteTimeout(connectionString, dataSource);
            DatabaseConnectionTestResult databaseConnectionTestResult = DatabaseConnectionTestResult.failure(ex);
            return databaseConnectionTestResult;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private String getUrl(DataSource dataSource) {
        if (dataSource instanceof SimpleDriverDataSource) {
            SimpleDriverDataSource simpleDriverDataSource = (SimpleDriverDataSource)dataSource;
            return simpleDriverDataSource.getUrl();
        }
        log.warn("Cannot find database URL. DataSource class [{}]", (Object)dataSource.getClass().getName());
        return "UNKNOWN";
    }
}

