/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database;

import com.suncode.dbexplorer.database.DatabaseType;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Embeddable
public class ConnectionStringDomain {
    @Column(name="db_type")
    private DatabaseType type;
    @Column(name="db_catalog")
    private String catalog;
    @Column(name="db_schema")
    private String schema;
    @Column(name="db_host")
    private String host;
    @Column(name="db_port")
    private Integer port;
    @Column(name="db_user")
    private String user;
    @Column(name="db_password")
    private String password;
    @Column(name="jdbc_url")
    private String jdbcUrl;

    public ConnectionStringDomain(DatabaseType type, String catalog, String schema, String host, Integer port, String user, String password, String jdbcUrl) {
        if (!this.notEmpty(jdbcUrl)) {
            Assert.notNull((Object)((Object)type), (String)"[Assertion failed] - this argument is required; it must not be null");
            Assert.hasText((String)host, (String)"Database host cannot be empty if JDBC URL is not specified");
        }
        this.type = type;
        this.catalog = catalog;
        this.schema = schema;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.jdbcUrl = jdbcUrl;
    }

    private boolean notEmpty(String string) {
        return StringUtils.hasText((String)string);
    }

    public static ConnectionStringDomainBuilder builder() {
        return new ConnectionStringDomainBuilder();
    }

    public ConnectionStringDomain() {
    }

    public DatabaseType getType() {
        return this.type;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public static class ConnectionStringDomainBuilder {
        private DatabaseType type;
        private String catalog;
        private String schema;
        private String host;
        private Integer port;
        private String user;
        private String password;
        private String jdbcUrl;

        ConnectionStringDomainBuilder() {
        }

        public ConnectionStringDomainBuilder type(DatabaseType type) {
            this.type = type;
            return this;
        }

        public ConnectionStringDomainBuilder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public ConnectionStringDomainBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public ConnectionStringDomainBuilder host(String host) {
            this.host = host;
            return this;
        }

        public ConnectionStringDomainBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public ConnectionStringDomainBuilder user(String user) {
            this.user = user;
            return this;
        }

        public ConnectionStringDomainBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ConnectionStringDomainBuilder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public ConnectionStringDomain build() {
            return new ConnectionStringDomain(this.type, this.catalog, this.schema, this.host, this.port, this.user, this.password, this.jdbcUrl);
        }

        public String toString() {
            return "ConnectionStringDomain.ConnectionStringDomainBuilder(type=" + String.valueOf((Object)this.type) + ", catalog=" + this.catalog + ", schema=" + this.schema + ", host=" + this.host + ", port=" + this.port + ", user=" + this.user + ", password=" + this.password + ", jdbcUrl=" + this.jdbcUrl + ")";
        }
    }
}

