/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.configurationtransfer;

import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.AliasService;
import com.suncode.dbexplorer.alias.TablesSet;
import com.suncode.dbexplorer.configurationtransfer.dto.ConfigurationDbExplorerRootDto;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.ConfigurationAliasConverter;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.ConfigurationAliasDto;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.tableset.ConfigurationTablesSetConverter;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.tableset.ConfigurationTablesSetDto;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.configuration.audit.ConfigurationTransferAudit;
import com.suncode.pwfl.configuration.dto.plugins.PluginConfigurationDtoRoot;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ConfigurationImporter {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationImporter.class);
    private final Plugin plugin;
    private final AliasService aliasService;
    private final UserFinder userFinder;
    private final UserGroupFinder userGroupFinder;
    private final ConfigurationAliasConverter configurationAliasConverter;
    private final ConfigurationTablesSetConverter configurationTablesSetConverter;

    @Transactional
    public void importConfig(PluginConfigurationDtoRoot configuration, ConfigurationTransferAudit importAudit) {
        this.validatePlugin(configuration);
        ConfigurationDbExplorerRootDto config = (ConfigurationDbExplorerRootDto)configuration;
        if (!config.getMetadata().isSelected()) {
            return;
        }
        List selectedAliases = config.getAliases().getOnlySelectedElements();
        if (!selectedAliases.isEmpty()) {
            this.importAliases(config.getAliases().getOnlySelectedElements(), importAudit);
        }
    }

    private void validatePlugin(PluginConfigurationDtoRoot configuration) {
        if (!this.plugin.getKey().equals(configuration.getPluginId())) {
            throw new PluginsException("The configuration object is not the " + this.plugin.getName() + " plugin configuration");
        }
    }

    private void importAliases(List<ConfigurationAliasDto> aliases, ConfigurationTransferAudit importAudit) {
        List<Alias> aliasesInBase = this.aliasService.getAliases();
        List allUsersInBase = this.userFinder.getAll(new String[0]);
        List allGroupsInBase = this.userGroupFinder.getAll(new String[0]);
        for (ConfigurationAliasDto aliasDto : aliases) {
            if (aliasDto.isSystemAlias()) {
                Optional<Alias> systemAlias = this.findSystemAlias(aliasesInBase);
                systemAlias.ifPresent(alias -> this.addTableSets((Alias)alias, aliasDto, allUsersInBase, allGroupsInBase));
                continue;
            }
            this.processAlias(aliasDto, allUsersInBase, allGroupsInBase, aliasesInBase, importAudit);
        }
    }

    private void addTableSets(Alias existentAlias, ConfigurationAliasDto aliasDto, List<User> users, List<UserGroup> groups) {
        List<ConfigurationTablesSetDto> selectedTableSets = aliasDto.getTableSets().getList().stream().filter(tableSet -> tableSet.getMetadata().isSelected()).filter(tableSet -> existentAlias.getTablesSets().stream().map(TablesSet::getName).noneMatch(setName -> StringUtils.equals((CharSequence)setName, (CharSequence)tableSet.getName()))).toList();
        for (ConfigurationTablesSetDto tablesSetDto : selectedTableSets) {
            existentAlias.addTablesSet(this.configurationTablesSetConverter.convertToEntity(tablesSetDto, users, groups));
        }
    }

    private void processAlias(ConfigurationAliasDto aliasDto, List<User> users, List<UserGroup> groups, List<Alias> aliasesInBase, ConfigurationTransferAudit importAudit) {
        Optional<Alias> existingAlias = this.checkAliasExistsInBase(aliasDto.getName(), aliasesInBase);
        if (existingAlias.isPresent()) {
            log.info("Alias with name {} already exists. Importing table sets...", (Object)existingAlias.get().getName());
            this.addTableSets(existingAlias.get(), aliasDto, users, groups);
        } else {
            Alias alias = this.configurationAliasConverter.convertToEntity(aliasDto, users, groups);
            this.aliasService.addAlias(alias);
        }
        importAudit.addElement("DB EXPLORER ALIAS", aliasDto.getName());
    }

    private Optional<Alias> findSystemAlias(List<Alias> aliasesInBase) {
        return aliasesInBase.stream().filter(Alias::getIsSystemAlias).findFirst();
    }

    private Optional<Alias> checkAliasExistsInBase(String aliasName, List<Alias> aliasesInBase) {
        return aliasesInBase.stream().filter(alias -> alias.getName().equals(aliasName)).findFirst();
    }

    @Autowired
    public ConfigurationImporter(Plugin plugin, AliasService aliasService, UserFinder userFinder, UserGroupFinder userGroupFinder, ConfigurationAliasConverter configurationAliasConverter, ConfigurationTablesSetConverter configurationTablesSetConverter) {
        this.plugin = plugin;
        this.aliasService = aliasService;
        this.userFinder = userFinder;
        this.userGroupFinder = userGroupFinder;
        this.configurationAliasConverter = configurationAliasConverter;
        this.configurationTablesSetConverter = configurationTablesSetConverter;
    }
}

