/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.permission.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.suncode.dbexplorer.alias.TablesSet;
import com.suncode.dbexplorer.alias.internal.TablesSetRepository;
import com.suncode.dbexplorer.alias.permission.AccessLevel;
import com.suncode.dbexplorer.alias.permission.AccessResource;
import com.suncode.dbexplorer.alias.permission.PermissionsService;
import com.suncode.dbexplorer.alias.permission.SecuredTablesSet;
import com.suncode.dbexplorer.alias.permission.TablesSetPermission;
import com.suncode.dbexplorer.alias.permission.internal.TablesSetPermissionRepository;
import com.suncode.dbexplorer.context.UserContext;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Transactional
public class PermissionsServiceImpl
implements PermissionsService {
    private final UserService userService;
    private final TablesSetRepository setRepository;
    private final TablesSetPermissionRepository setPermissionRepository;
    private final LoadingCache<String, List<SecuredTablesSet>> permissionsCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, List<SecuredTablesSet>>(){

        public List<SecuredTablesSet> load(String key) {
            return PermissionsServiceImpl.this.getSecuredTablesSets(key);
        }
    });

    @Override
    public AccessResource getResource(Long id, AccessResource.ResourceType type) {
        switch (type) {
            case USER: {
                return new AccessResource(this.userService.getUser(id, new String[0]));
            }
            case GROUP: {
                return new AccessResource(this.userService.getGroup(id, new String[0]));
            }
        }
        throw new IllegalStateException("Unknown resource type: " + String.valueOf((Object)type));
    }

    @Override
    public List<TablesSetPermission> getPermissions(Long setId) {
        DetachedCriteria criteria = DetachedCriteria.forClass(TablesSetPermission.class).add((Criterion)Restrictions.eq((String)"tablesSet.id", (Object)setId));
        List permissions = this.setPermissionRepository.findByCriteria(criteria);
        this.deleteRecordsWithNonExistingUser(permissions);
        return permissions;
    }

    private void deleteRecordsWithNonExistingUser(List<TablesSetPermission> permissions) {
        for (int i = permissions.size() - 1; i >= 0; --i) {
            TablesSetPermission permission = permissions.get(i);
            if (permission.getResource().getUser() != null || permission.getResource().getGroup() != null) continue;
            this.deletePermission(permission.getId());
            permissions.remove(permission);
        }
    }

    @Override
    public TablesSetPermission newPermission(Long setId, AccessResource resource, AccessLevel level) {
        TablesSet set = (TablesSet)this.setRepository.get(setId);
        if (set == null) {
            throw new IllegalArgumentException("Tables set with id [" + setId + "] does not exists!");
        }
        TablesSetPermission permission = this.setPermissionRepository.getResourcePermission(set, resource);
        if (permission != null) {
            permission.setLevel(level);
        } else {
            permission = new TablesSetPermission(set, level, resource);
            this.setPermissionRepository.save(permission);
        }
        this.permissionsCache.invalidateAll();
        return permission;
    }

    @Override
    public TablesSetPermission changePermissionLevel(Long permissionId, AccessLevel newLevel) {
        Assert.notNull((Object)((Object)newLevel), (String)"New level cannot be empty");
        TablesSetPermission permission = (TablesSetPermission)this.setPermissionRepository.get(permissionId);
        if (permission == null) {
            throw new IllegalArgumentException("Tables set permission with id [" + permissionId + "] not found!");
        }
        permission.setLevel(newLevel);
        this.permissionsCache.invalidateAll();
        return permission;
    }

    @Override
    public TablesSetPermission deletePermission(Long permissionId) {
        TablesSetPermission permission = (TablesSetPermission)this.setPermissionRepository.get(permissionId);
        if (permission != null) {
            this.setPermissionRepository.delete(permission);
            this.permissionsCache.invalidateAll();
        }
        return permission;
    }

    @Override
    public List<SecuredTablesSet> getSecuredTablesSets(String username) {
        HashMap sets = Maps.newHashMap();
        for (TablesSetPermission permission : this.getPermissionsForUser(username)) {
            TablesSet set = permission.getTablesSet();
            SecuredTablesSet curr = new SecuredTablesSet(set, permission.getLevel());
            SecuredTablesSet old = (SecuredTablesSet)sets.get(set.getName());
            if (old != null && !curr.getAccessLevel().isHigher(old.getAccessLevel())) continue;
            sets.put(curr.getName(), curr);
        }
        this.permissionsCache.put((Object)username, new ArrayList(sets.values()));
        return new ArrayList<SecuredTablesSet>(sets.values());
    }

    @Override
    public boolean hasPermissionToTable(String username, String tableName, AccessLevel accessLevel) {
        Set accessFilteredTables;
        try {
            accessFilteredTables = ((List)this.permissionsCache.get((Object)UserContext.userName())).stream().filter(securedTablesSet -> securedTablesSet.getAccessLevel().equals((Object)accessLevel) || securedTablesSet.getAccessLevel().isHigher(accessLevel)).map(SecuredTablesSet::getTables).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return accessFilteredTables.stream().anyMatch(table -> Objects.equals(table.getName(), tableName));
    }

    @Override
    public boolean hasAnyPermissions() {
        try {
            return !((List)this.permissionsCache.get((Object)UserContext.userName())).isEmpty();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private List<TablesSetPermission> getPermissionsForUser(String username) {
        User user = this.userService.getUser(username, new String[]{"groups"});
        return this.setPermissionRepository.getPermissionsForUser(user);
    }

    @Autowired
    public PermissionsServiceImpl(UserService userService, TablesSetRepository setRepository, TablesSetPermissionRepository setPermissionRepository) {
        this.userService = userService;
        this.setRepository = setRepository;
        this.setPermissionRepository = setPermissionRepository;
    }
}

