/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.data.dto;

import com.google.common.collect.Lists;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.Table;
import com.suncode.dbexplorer.alias.dto.SimpleTableDto;
import com.suncode.dbexplorer.alias.dto.TableDto;
import com.suncode.dbexplorer.alias.permission.AccessLevel;
import com.suncode.dbexplorer.alias.permission.SecuredTablesSet;
import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseFactory;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuredTablesSetDto {
    private static final Logger log = LoggerFactory.getLogger(SecuredTablesSetDto.class);
    private String name;
    private AccessLevel accessLevel;
    private Boolean available;
    private List<TableDto> tables = Lists.newArrayList();

    public SecuredTablesSetDto(DatabaseFactory databaseFactory, SecuredTablesSet securedSet) {
        this.name = securedSet.getName();
        this.accessLevel = securedSet.getAccessLevel();
        this.available = true;
        Alias alias = securedSet.getSet().getAlias();
        Set<SimpleTableDto> setTables = securedSet.getTables();
        Set<Table> tables = alias.getTables(databaseFactory);
        String defaultSchema = this.getDefaultSchema(databaseFactory, alias);
        for (SimpleTableDto tableDto : setTables) {
            if (StringUtils.isEmpty((CharSequence)tableDto.getSchema())) {
                tableDto.setSchema(defaultSchema);
            }
            for (Table table : tables) {
                if (!table.getSchema().equals(tableDto.getSchema()) || !table.getName().equals(tableDto.getName())) continue;
                this.tables.add(new TableDto(alias, table));
            }
        }
    }

    private String getDefaultSchema(DatabaseFactory databaseFactory, Alias alias) {
        Database database = databaseFactory.create(alias.getWrappedConnectionString());
        return database.getDefaultSchemaName();
    }

    public static List<SecuredTablesSetDto> from(DatabaseFactory databaseFactory, Collection<SecuredTablesSet> securedSets) {
        ExecutorService executor = Executors.newFixedThreadPool(securedSets.size());
        Map<Integer, Future> isAvailableMap = securedSets.stream().map(set -> {
            try {
                return SecuredTablesSetDto.getConnectionString(set);
            }
            catch (Exception e) {
                log.info("Exception while fetching alias: {}, message: {}", (Object)set.getName(), (Object)e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).distinct().collect(Collectors.toMap(ConnectionString::hashCode, connectionString -> executor.submit(() -> databaseFactory.isAvailable((ConnectionString)connectionString))));
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.MINUTES);
        return securedSets.stream().map(set -> {
            try {
                ConnectionString connectionString;
                try {
                    connectionString = SecuredTablesSetDto.getConnectionString(set);
                }
                catch (Exception e) {
                    log.info("Exception while fetching alias: {}, message: {}", (Object)set.getName(), (Object)e.getMessage());
                    return null;
                }
                Future futureAvailable = (Future)isAvailableMap.get(connectionString.hashCode());
                if (((Boolean)futureAvailable.get()).booleanValue()) {
                    return new SecuredTablesSetDto(databaseFactory, (SecuredTablesSet)set);
                }
                return SecuredTablesSetDto.unavailable(set);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static ConnectionString getConnectionString(SecuredTablesSet set) {
        return set.getSet().getAlias().getWrappedConnectionString();
    }

    public static SecuredTablesSetDto unavailable(SecuredTablesSet securedSet) {
        SecuredTablesSetDto dto = new SecuredTablesSetDto();
        dto.setName(securedSet.getName());
        dto.setAccessLevel(securedSet.getAccessLevel());
        dto.setAvailable(false);
        dto.setTables(new LinkedList<TableDto>());
        return dto;
    }

    public String getName() {
        return this.name;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public Boolean getAvailable() {
        return this.available;
    }

    public List<TableDto> getTables() {
        return this.tables;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
    }

    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public void setTables(List<TableDto> tables) {
        this.tables = tables;
    }

    public SecuredTablesSetDto() {
    }
}

