/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.data;

import com.suncode.dbexplorer.database.type.BasicDataType;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;

public class CreateTable {
    private String name;
    private String schema;
    private Set<Column> columns;
    private Set<ForeignKey> foreignKeys = new HashSet<ForeignKey>();

    public CreateTable(String name, Set<Column> columns) {
        this("", name, columns);
    }

    public CreateTable(String schema, String name, Set<Column> columns) {
        this.name = name;
        this.schema = schema;
        this.columns = columns;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public Set<Column> getColumns() {
        return this.columns;
    }

    public Set<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(Set<ForeignKey> foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    public static class ForeignKey {
        private String columnName;
        private String foreignTableName;
        private String foreignColumnName;

        public String getColumnName() {
            return this.columnName;
        }

        public String getForeignTableName() {
            return this.foreignTableName;
        }

        public String getForeignColumnName() {
            return this.foreignColumnName;
        }

        public ForeignKey(String columnName, String foreignTableName, String foreignColumnName) {
            this.columnName = columnName;
            this.foreignTableName = foreignTableName;
            this.foreignColumnName = foreignColumnName;
        }
    }

    public static class Column {
        @NonNull
        private String name;
        @NonNull
        private BasicDataType dataType;
        private boolean nullable;
        private boolean autoIncrement;
        private boolean primaryKey;

        @NonNull
        public String getName() {
            return this.name;
        }

        @NonNull
        public BasicDataType getDataType() {
            return this.dataType;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public void setNullable(boolean nullable) {
            this.nullable = nullable;
        }

        public void setAutoIncrement(boolean autoIncrement) {
            this.autoIncrement = autoIncrement;
        }

        public void setPrimaryKey(boolean primaryKey) {
            this.primaryKey = primaryKey;
        }

        public Column(@NonNull String name, @NonNull BasicDataType dataType) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (dataType == null) {
                throw new NullPointerException("dataType is marked non-null but is null");
            }
            this.name = name;
            this.dataType = dataType;
        }
    }
}

