/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias;

import com.suncode.dbexplorer.alias.settings.ColumnSettings;
import com.suncode.dbexplorer.database.schema.ColumnSchema;
import org.springframework.util.Assert;

public class Column {
    private final ColumnSchema column;
    private final ColumnSettings settings;

    public Column(ColumnSchema column, ColumnSettings settings) {
        Assert.notNull((Object)column, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull((Object)settings, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.state((boolean)column.getName().equals(settings.getColumnName()), (String)"[Assertion failed] - this state invariant must be true");
        this.column = column;
        this.settings = settings;
    }

    public String getName() {
        return this.column.getName();
    }

    public String getDisplayName() {
        return this.settings.getDisplayName();
    }

    public ColumnSchema getColumnSchema() {
        return this.column;
    }
}

