package com.suncode.dbexplorer.util.web.rest;

import org.springframework.http.HttpStatus;

@SuppressWarnings( "serial" )
public class RestApiException
    extends RuntimeException
{

    private final RestApiError error;

    public RestApiException( HttpStatus httpStatus )
    {
        this.error = new RestApiError( httpStatus );
    }

    public RestApiException( RestApiError error )
    {
        this.error = error;
    }

    public RestApiError getError()
    {
        return error;
    }

    public RestApiException message( String message )
    {
        error.setMessage( message );
        return this;
    }

    public RestApiException message( String message, Object... args )
    {
        message( String.format( message, args ) );
        return this;
    }

    public RestApiException userMessage( String userMessage )
    {
        error.setUserMessage( userMessage );
        return this;
    }

    public RestApiException userMessage( String userMessage, Object... args )
    {
        userMessage( String.format( userMessage, args ) );
        return this;
    }

}
