package com.suncode.dbexplorer.util.web;

import com.suncode.dbexplorer.util.authorization.AuthorizationHelper;
import lombok.RequiredArgsConstructor;
import org.enhydra.shark.Shark;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.sql.SQLException;

@Controller
@RequiredArgsConstructor( onConstructor_ = { @Autowired } )
public class ViewController
{
    private static final String CONFIGURATION_VIEW = "config";

    private static final String EXPLORER_VIEW = "explorer";

    private static final String DECIMAL_SEPARATOR = Shark.getInstance().getProperties()
        .getProperty( "DecimalSeparator", "." );

    private final AuthorizationHelper authorizationHelper;

    @RequestMapping( "/" )
    public String explorer( @RequestParam( required = false ) Boolean debug, Model model )
    {
        model.addAttribute( "decimalSeparator", DECIMAL_SEPARATOR );
        model.addAttribute( "debug", debug );
        return EXPLORER_VIEW;
    }

    @RequestMapping( "/configure" )
    public String configuration( @RequestParam( required = false ) Boolean debug, Model model )
        throws SQLException
    {
        authorizationHelper.assertFullAdministrationRights( () -> {
        } );

        model.addAttribute( "debug", debug );
        return CONFIGURATION_VIEW;
    }
}
