package com.suncode.dbexplorer.util.web;

import org.springframework.util.StringUtils;

import com.suncode.dbexplorer.database.query.Order;
import com.suncode.dbexplorer.database.query.Order.OrderType;
import com.suncode.dbexplorer.database.query.Pagination;

public class Paging
{
    private int page;

    private String sort;

    private String dir;

    public Pagination pagination()
    {
        Pagination pagination = new Pagination( page );

        if ( StringUtils.hasText( sort ) )
        {
            pagination.addOrder( new Order( sort, OrderType.valueOf( dir ) ) );
        }
        return pagination;
    }

    public void setPage( int page )
    {
        this.page = page;
    }

    public void setSort( String sort )
    {
        this.sort = sort;
    }

    public void setDir( String dir )
    {
        this.dir = dir;
    }
}