package com.suncode.dbexplorer.util.persistence;

import jakarta.persistence.Column;
import jakarta.persistence.Lob;
import jakarta.persistence.MappedSuperclass;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * Klasa ułatwia mapowanie dowolnego obiektu do postaci JSON zapisanego w bazie danych w kolumnie
 * BLOB.
 * 
 * @param <T> przechowywany typ
 * @author Cezary Kozar 16 sty 2016
 */
@MappedSuperclass
public abstract class Json<T>
{
    /**
     * Nazwa pola przechowującego zserializowaną postac mapowanego obiektu
     */
    public static final String COLUMN = "serialized";

    @Lob
    @Column
    @JsonIgnore
    private byte[] serialized = new byte[0];

    /**
     * Kopiuje stan odczytanego z bazy danych obiektu do tej instancji.
     * 
     * @param serialized obiekt odczytany z bazy danych
     */
    protected abstract void apply( T serialized );

    /*
     * PACKAGE PRIVATE
     */

    public byte[] getSerialized()
    {
        return serialized;
    }

    void setSerialized( byte[] serialized )
    {
        this.serialized = serialized;
    }
}
