package com.suncode.dbexplorer.util.persistence;

import java.io.Serializable;

import org.hibernate.EmptyInterceptor;
import org.hibernate.Interceptor;
import org.hibernate.type.Type;
import org.springframework.context.ApplicationContext;

/**
 * {@linkplain Interceptor} który do każdej załadowanej encji wstrzykuje zależności, jeżeli encja ta
 * oznaczona jest adnotacją {@literal @}Injectable {@linkplain Injectable};
 * 
 * @author Cezary Kozar 16 sty 2016
 */
@SuppressWarnings( "serial" )
public class EntityInjector
    extends EmptyInterceptor
{
    private final ApplicationContext context;

    public EntityInjector( ApplicationContext context )
    {
        this.context = context;
    }

    @Override
    public boolean onLoad( Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types )
    {
        boolean changed = inject( entity );
        for ( Object object : state )
        {
            changed |= inject( object );
        }
        return changed;
    }

    private boolean inject( Object object )
    {
        if ( object != null && object.getClass().isAnnotationPresent( Injectable.class ) )
        {
            context.getAutowireCapableBeanFactory().autowireBean( object );
            return true;
        }
        return false;
    }
}
