package com.suncode.dbexplorer.util.persistence;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.SequenceGenerator;

@MappedSuperclass
public abstract class BaseEntity {

	private static final String SEQ = "dbex_id_seq";

	@Id
	@GeneratedValue(generator = SEQ)
	@SequenceGenerator(name = SEQ, sequenceName = SEQ)
	private Long id;

	public Long getId() {
		return id;
	}
}
