package com.suncode.dbexplorer.upgrade;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.plusmpm.security.TextCipher;
import com.suncode.pwfl.database.DataSourceFactory;

import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class EncryptPasswordsChange implements CustomTaskChange
{
    
    @Override
    public void execute( Database database )
        throws CustomChangeException
    {
        try (Connection connection = DataSourceFactory.getDataSource().getConnection()){
            try {
                connection.setAutoCommit( false );
                Map<Integer, String> passwords = getPasswordsFromDbexAlias(connection);
                
                log.debug( "Encrypting passwords" );
                passwords.forEach( (id, password) -> encodePassword(connection, id, password) );
                connection.commit();
                               
            }
            catch(Exception e )
            {
                connection.rollback();
                throw new RuntimeException(e);
            }
        }
        catch ( Throwable t )
        {
           throw new CustomChangeException(t);
        }     
    }   
    
    private Map<Integer, String> getPasswordsFromDbexAlias( Connection connection ) throws SQLException
    {       
        Map<Integer, String> passwords = new HashMap<>();
        String query = "SELECT id, db_password FROM dbex_alias";
        PreparedStatement statement = connection.prepareStatement( query );
        ResultSet resultSet = statement.executeQuery();
        while ( resultSet.next() )
        { 
            String password = resultSet.getString( "db_password" );
            if ( StringUtils.isNotBlank( password ) )
            {
                passwords.put( resultSet.getInt( "id" ), password );
            }
        }
        return passwords;
    }
    
    @SneakyThrows
    private void encodePassword(Connection connection, int id, String password){

        String updateQuery = "UPDATE DBEX_ALIAS SET DB_PASSWORD = ? WHERE ID = ? ";
        PreparedStatement updateStatement = connection.prepareStatement( updateQuery );
        updateStatement.setString( 1, TextCipher.encrypt( password ) );
        updateStatement.setInt( 2, id );
        updateStatement.executeUpdate();
    }
    
    @Override
    public String getConfirmationMessage()
    {
        return null;
    }

    @Override
    public void setUp()       
    {
    }

    @Override
    public void setFileOpener( ResourceAccessor resourceAccessor )
    {        
    }

    @Override
    public ValidationErrors validate( Database database )
    {
        return null;
    }
   
}
