package com.suncode.dbexplorer.providers;

import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.AliasService;
import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.internal.DatabaseFactoryImpl;
import com.suncode.dbexplorer.database.internal.DatabaseImplementor;
import com.suncode.pwfl.plugin.modules.dbconfig.DatabaseConnectionConfig;
import com.suncode.pwfl.plugin.modules.dbconfig.DatabaseConnectionConfigProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.LinkedList;
import java.util.List;

@Component
public class DatabaseProvider implements DatabaseConnectionConfigProvider
{
   
    @Autowired
    private DatabaseFactoryImpl databaseFactoryImpl;
    
    @Autowired
    private AliasService aliasService;

    @Override
    public List<DatabaseConnectionConfig> getDatabaseConnectionConfigs()
    {
        List<DatabaseConnectionConfig> configs = new LinkedList<>();

        for ( Alias alias : aliasService.getActiveAliases() )
        {
            ConnectionString connString = alias.getWrappedConnectionString();

            DatabaseConnectionConfig config = new DatabaseConnectionConfig();
            config.setId( "" + alias.getId() );
            config.setName( alias.getName() );
            config.setUsername( connString.getUser() );
            config.setPassword( connString.getPassword() );

            DatabaseImplementor dbImplementor = databaseFactoryImpl.resolveDatabaseType( connString );
            config.setDriverClassName( dbImplementor.getDriverClass().getName() );
            config.setJdbcUrl( dbImplementor.buildConnectionUrl( connString ) );

            configs.add( config );
        }
        
        return configs;
    }

}
