package com.suncode.dbexplorer.internal;

import com.suncode.dbexplorer.DatabaseExplorer;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.AliasNotFoundException;
import com.suncode.dbexplorer.alias.AliasService;
import com.suncode.dbexplorer.alias.exception.AliasNotActiveException;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseFactory;
import com.suncode.plugin.framework.service.Provides;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

/**
 * @author Cezary Kozar 12 lip 2016
 */
@Service
@Provides( DatabaseExplorer.class )
public class DatabaseExplorerImpl
    implements DatabaseExplorer
{
    private AliasService aliasService;

    private DatabaseFactory databaseFactory;

    public @Autowired DatabaseExplorerImpl( AliasService aliasService, DatabaseFactory databaseFactory )
    {
        Assert.notNull( aliasService, "[Assertion failed] - this argument is required; it must not be null" );
        Assert.notNull( databaseFactory, "[Assertion failed] - this argument is required; it must not be null" );
        this.aliasService = aliasService;
        this.databaseFactory = databaseFactory;
    }

    @Override
    public Database get( String name )
        throws AliasNotFoundException
    {
        Alias alias = aliasService.getAlias( name );
        if ( alias == null )
        {
            throw new AliasNotFoundException( name );
        }

        if ( !alias.getIsActive() )
        {
            Translator translator = Translators.get( DatabaseExplorerImpl.class );
            throw new AliasNotActiveException( translator.getMessage( "dbex.alias.notActive.exception", alias.getName() ) );
        }

        return databaseFactory.create( alias.getWrappedConnectionString() );
    }

    @Override
    public AliasService getAliasService()
    {
        return aliasService;
    }

    @Override
    public DatabaseFactory getDatabaseFactory()
    {
        return databaseFactory;
    }
}
