package com.suncode.dbexplorer.database.type.support;

import org.springframework.util.Assert;

import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.dbexplorer.database.type.NativeType;

public abstract class AbstractDataType implements DataType {

	private final NativeType nativeType;

	public AbstractDataType(NativeType nativeType) {
		Assert.notNull( nativeType, "[Assertion failed] - this argument is required; it must not be null" );
		this.nativeType = nativeType;
	}

	@Override
	public NativeType getNativeType() {
		return nativeType;
	}

	@Override
	public String toString() {
		return getName() + " " + nativeType.toString();
	}
}
