package com.suncode.dbexplorer.database.type;

/**
 * @author Cezary Kozar 23 wrz 2015
 */
public class NativeType
{
	private final String name;

	private final int sqlType;

	private final Integer length;

	public NativeType(String name, int sqlType)
	{
		this(name, sqlType, null);
	}

	public NativeType(String name, int sqlType, Integer length)
	{
		this.name = name;
		this.sqlType = sqlType;
		this.length = length;
	}

	public String getName()
	{
		return name;
	}

	public int getSqlType() {
		return sqlType;
	}

	public Integer getLength()
	{
		return length;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder()
			.append("native(")
			.append(name);
		if (length != null) {
			sb.append("[").append(length).append("]");
		}
		return sb.append(" JDBC[").append(sqlType).append("])")
			.toString();
	}
}