package com.suncode.dbexplorer.database.type;

import com.suncode.dbexplorer.database.schema.ColumnSchema;

public enum BasicDataType
{
    STRING( StringDataType.class ),
    INTEGER( IntegerDataType.class ),
    FLOAT( FloatDataType.class ),
    DATETIME( DateTimeDataType.class ),
    DATE( DateDataType.class ),
    TIME( TimeDataType.class ),
    BOOLEAN( BooleanDataType.class ),
    BINARY( BinaryDataType.class ),
    UNKNOWN( UnknownDataType.class );

    private Class<? extends DataType> typeClass;

    private BasicDataType( Class<? extends DataType> typeClass )
    {
        this.typeClass = typeClass;
    }

    public boolean is( DataType dataType )
    {
        return this.typeClass.equals( dataType.getClass() );
    }

    public static boolean is( DataType dataType, BasicDataType basicDataType )
    {
        return basicDataType.typeClass.equals( dataType.getClass() );
    }

    public static BasicDataType of( DataType dataType )
    {
        for ( BasicDataType enumType : values() )
        {
            if ( is( dataType, enumType ) )
            {
                return enumType;
            }
        }
        return null;
    }
}
